/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IBilledBuilder;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IBilledBuilderTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createEncounter();
        super.createLocalArticle();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void build() {
        IBilled billed = (IBilled)new IBilledBuilder(this.coreModelService, (IBillable)this.localArticle, this.encounter, (IContact)this.mandator).buildAndSave();
        Assert.assertEquals((Object)this.encounter, (Object)billed.getEncounter());
        Assert.assertEquals((Object)"test article", (Object)billed.getText());
        Assert.assertEquals((Object)"123456789", (Object)billed.getCode());
        Assert.assertEquals((Object)"class ch.elexis.core.model.TypedArticle", (Object)billed.getBillable().getClass().toString());
        Assert.assertEquals((double)1.0, (double)billed.getAmount(), (double)0.01);
        Assert.assertEquals((Object)new Money(0), (Object)billed.getTotal());
        Assert.assertEquals((Object)new Money(0), (Object)billed.getPrice());
        Assert.assertEquals((double)1.0, (double)billed.getFactor(), (double)0.01);
        Assert.assertEquals((Object)"test article", (Object)billed.getLabel());
        Assert.assertEquals((Object)new Money(0), (Object)billed.getNetPrice());
        Assert.assertEquals((long)0L, (long)billed.getPoints());
        Assert.assertEquals((long)100L, (long)billed.getPrimaryScale());
        Assert.assertEquals((double)1.0, (double)billed.getPrimaryScaleFactor(), (double)0.01);
        Assert.assertEquals((Object)new Money(0), (Object)billed.getScaledPrice());
        Assert.assertEquals((long)100L, (long)billed.getSecondaryScale());
        Assert.assertEquals((double)1.0, (double)billed.getSecondaryScaleFactor(), (double)0.01);
        Assert.assertEquals((Object)this.mandator.getId(), (Object)billed.getBiller().getId());
        this.coreModelService.remove((Identifiable)billed);
    }
}

