/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting.beanshell;

import bsh.EvalError;
import bsh.ParseException;
import bsh.TargetError;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Script;
import ch.elexis.scripting.beanshell.internal.MultiClassLoader;
import ch.rgw.tools.ExHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class Interpreter
implements ch.elexis.core.data.interfaces.scripting.Interpreter,
IExecutableExtension {
    private bsh.Interpreter scripter = new bsh.Interpreter();
    private MultiClassLoader multiClassLoader = new MultiClassLoader(ch.elexis.core.data.interfaces.scripting.Interpreter.classLoaders);

    public void setValue(String name, Object value) throws ElexisException {
        try {
            this.scripter.set(name, value);
        }
        catch (EvalError e) {
            ExHandler.handle((Throwable)e);
            throw new ElexisException(this.getClass(), e.getMessage(), 3);
        }
    }

    public Object run(String script, boolean showErrors) throws ElexisException {
        try {
            this.scripter.setClassLoader((ClassLoader)this.multiClassLoader);
            return this.scripter.eval(script);
        }
        catch (TargetError e) {
            if (showErrors) {
                StringBuilder sb = new StringBuilder();
                sb.append("Script Error: " + String.valueOf(e.getTarget()) + "\n\n");
                sb.append(e.getMessage());
                MessageEvent.fireError((String)"Script target Error", (String)sb.toString());
            }
            throw new ElexisException(Script.class, e.getMessage(), 3);
        }
        catch (ParseException e) {
            String msg = "";
            if (e != null) {
                try {
                    msg = e.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    msg = "unbekannter Fehler";
                }
            }
            if (showErrors) {
                String line = "Script Syntax Fehler " + msg;
                String titel = "Script syntax Error";
                MessageEvent.fireError((String)titel, (String)line);
            }
            throw new ElexisException(this.getClass(), e.getMessage(), 3);
        }
        catch (EvalError e) {
            if (showErrors) {
                StringBuilder sb = new StringBuilder();
                sb.append("Script Error: " + e.getErrorText() + "\n\n");
                sb.append(e.getMessage());
                MessageEvent.fireError((String)"Script general error", (String)sb.toString());
            }
            throw new ElexisException(Script.class, "Allgemeiner Script Fehler: " + e.getErrorText(), 3);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

