/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Bestellung;
import ch.elexis.core.jpa.entities.BestellungEntry;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.util.internal.ModelUtil;
import java.util.Optional;

public class OrderEntry
extends AbstractIdDeleteModelAdapter<BestellungEntry>
implements IdentifiableWithXid,
IOrderEntry {
    public OrderEntry(BestellungEntry entity) {
        super((EntityWithId)entity);
    }

    public IOrder getOrder() {
        if (((BestellungEntry)this.getEntity()).getBestellung() != null) {
            return ModelUtil.getAdapter((EntityWithId)((BestellungEntry)this.getEntity()).getBestellung(), IOrder.class);
        }
        return null;
    }

    public void setOrder(IOrder value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((BestellungEntry)this.getEntityMarkDirty()).setBestellung((Bestellung)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((BestellungEntry)this.getEntityMarkDirty()).setBestellung(null);
        }
        this.addRefresh((Identifiable)value);
    }

    public IStock getStock() {
        String stockId = ((BestellungEntry)this.getEntity()).getStockid();
        if (stockId != null && !stockId.isEmpty()) {
            return ModelUtil.load(stockId, IStock.class);
        }
        return null;
    }

    public void setStock(IStock value) {
        ((BestellungEntry)this.getEntityMarkDirty()).setStockid(value != null ? value.getId() : null);
    }

    public int getAmount() {
        return ((BestellungEntry)this.getEntity()).getCount();
    }

    public void setAmount(int value) {
        ((BestellungEntry)this.getEntityMarkDirty()).setCount(value);
    }

    public int getDelivered() {
        return ((BestellungEntry)this.getEntity()).getDelivered();
    }

    public void setDelivered(int value) {
        ((BestellungEntry)this.getEntityMarkDirty()).setDelivered(value);
    }

    public IArticle getArticle() {
        Optional<Identifiable> loaded = ModelUtil.getFromStoreToString(((BestellungEntry)this.getEntity()).getArticleType() + "::" + ((BestellungEntry)this.getEntity()).getArticleId());
        if (loaded.isPresent() && loaded.get() instanceof IArticle) {
            return (IArticle)loaded.get();
        }
        return null;
    }

    public void setArticle(IArticle article) {
        String storeToString = ModelUtil.getStoreToString((Identifiable)article).orElseThrow(() -> new IllegalStateException("Could not get store to string for [" + String.valueOf(article) + "]"));
        String[] split = storeToString.split("::");
        if (split == null || split.length != 2) {
            throw new IllegalStateException("Could not set article [" + storeToString + "]");
        }
        ((BestellungEntry)this.getEntityMarkDirty()).setArticleType(split[0]);
        ((BestellungEntry)this.getEntityMarkDirty()).setArticleId(split[1]);
    }

    public IContact getProvider() {
        String providerId = ((BestellungEntry)this.getEntity()).getProviderId();
        if (providerId != null && !providerId.isEmpty()) {
            return ModelUtil.load(providerId, IContact.class);
        }
        return null;
    }

    public void setProvider(IContact value) {
        ((BestellungEntry)this.getEntityMarkDirty()).setProviderId(value != null ? value.getId() : null);
    }

    public OrderEntryState getState() {
        return OrderEntryState.ofValue((int)((BestellungEntry)this.getEntity()).getState());
    }

    public void setState(OrderEntryState value) {
        ((BestellungEntry)this.getEntityMarkDirty()).setState(value.getValue().intValue());
    }
}

