/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.VerrechnetCopy;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.service.holder.StoreToStringServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.rgw.tools.Money;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InvoiceBilled
extends AbstractIdDeleteModelAdapter<VerrechnetCopy>
implements IdentifiableWithXid,
IInvoiceBilled {
    public InvoiceBilled(VerrechnetCopy entity) {
        super((EntityWithId)entity);
    }

    public IBillable getBillable() {
        String billableClass = ((VerrechnetCopy)this.getEntity()).getKlasse();
        String billableId = ((VerrechnetCopy)this.getEntity()).getLeistungenCode();
        if (StringUtils.isNotBlank((CharSequence)billableClass) && StringUtils.isNotBlank((CharSequence)billableId)) {
            return StoreToStringServiceHolder.get().loadFromString(billableClass + "::" + billableId).orElse(null);
        }
        return null;
    }

    public void setBillable(IBillable value) {
        throw new UnsupportedOperationException();
    }

    public IEncounter getEncounter() {
        if (((VerrechnetCopy)this.getEntity()).getBehandlung() != null) {
            return ModelUtil.getAdapter((EntityWithId)((VerrechnetCopy)this.getEntity()).getBehandlung(), IEncounter.class);
        }
        return null;
    }

    public void setEncounter(IEncounter value) {
        if (value instanceof AbstractIdModelAdapter) {
            ((VerrechnetCopy)this.getEntityMarkDirty()).setBehandlung((Behandlung)((AbstractIdModelAdapter)value).getEntity());
        } else if (value == null) {
            ((VerrechnetCopy)this.getEntityMarkDirty()).setBehandlung(null);
        }
    }

    public double getAmount() {
        if (this.getSecondaryScale() == 100) {
            return ((VerrechnetCopy)this.getEntity()).getZahl();
        }
        return (double)this.getSecondaryScale() / 100.0;
    }

    public void setAmount(double value) {
        throw new UnsupportedOperationException();
    }

    public Money getPrice() {
        return new Money(this.getPoints()).multiply(this.getFactor());
    }

    public Money getScaledPrice() {
        int cents = Math.toIntExact(Math.round((double)this.getPoints() * this.getFactor() * this.getPrimaryScaleFactor()));
        return new Money(cents);
    }

    public void setPrice(Money value) {
        throw new UnsupportedOperationException();
    }

    public Money getNetPrice() {
        return new Money(((VerrechnetCopy)this.getEntity()).getEk_kosten());
    }

    public void setNetPrice(Money value) {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return ((VerrechnetCopy)this.getEntity()).getLeistungenText();
    }

    public void setText(String value) {
        throw new UnsupportedOperationException();
    }

    public int getPoints() {
        return ((VerrechnetCopy)this.getEntity()).getVk_tp();
    }

    public void setPoints(int value) {
        throw new UnsupportedOperationException();
    }

    public double getFactor() {
        String scaleString = ((VerrechnetCopy)this.getEntity()).getVk_scale();
        if (scaleString != null && !scaleString.isEmpty()) {
            try {
                return Double.parseDouble(scaleString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0;
    }

    public void setFactor(double value) {
        throw new UnsupportedOperationException();
    }

    public int getPrimaryScale() {
        return ((VerrechnetCopy)this.getEntity()).getScale();
    }

    public void setPrimaryScale(int value) {
        throw new UnsupportedOperationException();
    }

    public int getSecondaryScale() {
        return ((VerrechnetCopy)this.getEntity()).getScale2();
    }

    public void setSecondaryScale(int value) {
        throw new UnsupportedOperationException();
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public void setExtInfo(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public String getCode() {
        return ((VerrechnetCopy)this.getEntity()).getLeistungenCode();
    }

    public Money getTotal() {
        int cents = Math.toIntExact(Math.round((double)this.getPoints() * this.getFactor() * this.getPrimaryScaleFactor() * this.getSecondaryScaleFactor() * (double)((VerrechnetCopy)this.getEntity()).getZahl()));
        return new Money(cents);
    }

    public boolean isChangedPrice() {
        Object changedPrice = this.getExtInfo("changedPrice");
        if (changedPrice instanceof String) {
            return ((String)changedPrice).equalsIgnoreCase("true");
        }
        if (changedPrice instanceof Boolean) {
            return (Boolean)changedPrice;
        }
        return false;
    }

    public boolean isNonIntegerAmount() {
        if (this.isChangedPrice()) {
            return false;
        }
        return this.getSecondaryScale() != 100;
    }

    public IInvoice getInvoice() {
        return ModelUtil.getAdapter((EntityWithId)((VerrechnetCopy)this.getEntity()).getInvoice(), IInvoice.class);
    }

    public void setInvoice(IInvoice value) {
        if (this.getInvoice() != null) {
            this.addRefresh((Identifiable)this.getInvoice());
        }
        if (value instanceof AbstractIdModelAdapter) {
            ((VerrechnetCopy)this.getEntityMarkDirty()).setInvoice((Invoice)((AbstractIdModelAdapter)value).getEntity());
            this.addRefresh((Identifiable)value);
        } else if (value == null) {
            ((VerrechnetCopy)this.getEntityMarkDirty()).setInvoice(null);
        }
    }

    public double getPrimaryScaleFactor() {
        if (this.getPrimaryScale() == 0) {
            return 1.0;
        }
        return (double)this.getPrimaryScale() / 100.0;
    }

    public double getSecondaryScaleFactor() {
        if (this.getSecondaryScale() == 0) {
            return 1.0;
        }
        return (double)this.getSecondaryScale() / 100.0;
    }

    public IContact getBiller() {
        return ModelUtil.getAdapter((EntityWithId)((VerrechnetCopy)this.getEntity()).getUser(), IContact.class);
    }

    public void setBiller(IContact value) {
        throw new UnsupportedOperationException();
    }

    public void copy(IBilled to) {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return this.getText();
    }
}

