/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.Diagnosis;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.service.holder.ContextServiceHolder;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.time.TimeUtil;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.LoggerFactory;

public class Encounter
extends AbstractIdDeleteModelAdapter<Behandlung>
implements IdentifiableWithXid,
IEncounter {
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmmss");

    public Encounter(Behandlung entity) {
        super((EntityWithId)entity);
    }

    public LocalDateTime getTimeStamp() {
        String time = ((Behandlung)this.getEntity()).getTime();
        if (StringUtils.isNotBlank((CharSequence)time)) {
            return LocalDateTime.of(((Behandlung)this.getEntity()).getDatum(), LocalTime.parse(time, this.timeFormatter));
        }
        return this.getDate().atStartOfDay();
    }

    public void setTimeStamp(LocalDateTime value) {
        Behandlung entity = (Behandlung)this.getEntityMarkDirty();
        entity.setDatum(value.toLocalDate());
        entity.setTime(this.timeFormatter.format(value));
    }

    public IPatient getPatient() {
        if (((Behandlung)this.getEntity()).getFall() != null) {
            return ModelUtil.getAdapter((EntityWithId)((Behandlung)this.getEntity()).getFall().getPatient(), IPatient.class, true);
        }
        return null;
    }

    public ICoverage getCoverage() {
        return ModelUtil.getAdapter((EntityWithId)((Behandlung)this.getEntity()).getFall(), ICoverage.class);
    }

    public void setCoverage(ICoverage value) {
        if (this.getCoverage() != null) {
            this.addRefresh((Identifiable)this.getCoverage());
        }
        if (value instanceof AbstractIdModelAdapter) {
            ((Behandlung)this.getEntityMarkDirty()).setFall((Fall)((AbstractIdModelAdapter)value).getEntity());
            this.addRefresh((Identifiable)value);
        } else if (value == null) {
            ((Behandlung)this.getEntityMarkDirty()).setFall(null);
        }
    }

    public IMandator getMandator() {
        return ModelUtil.getAdapter((EntityWithId)((Behandlung)this.getEntity()).getMandant(), IMandator.class, true);
    }

    public void setMandator(IMandator value) {
        if (value != null) {
            ((Behandlung)this.getEntityMarkDirty()).setMandant((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Behandlung)this.getEntityMarkDirty()).setMandant(null);
        }
    }

    public List<IBilled> getBilled() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Behandlung)this.getEntity()).getBilled().parallelStream().filter(b -> !b.isDeleted()).map(b -> ModelUtil.getAdapter((EntityWithId)b, IBilled.class, true)).collect(Collectors.toList());
    }

    public void removeBilled(IBilled billed) {
        CoreModelServiceHolder.get().delete((Deleteable)billed);
    }

    public LocalDate getDate() {
        return ((Behandlung)this.getEntity()).getDatum();
    }

    public void setDate(LocalDate value) {
        Behandlung entity = (Behandlung)this.getEntityMarkDirty();
        entity.setDatum(value);
        entity.setTime("000000");
    }

    public VersionedResource getVersionedEntry() {
        return ((Behandlung)this.getEntity()).getEintrag();
    }

    public void setVersionedEntry(VersionedResource value) {
        ((Behandlung)this.getEntityMarkDirty()).setEintrag(value);
    }

    public List<IDiagnosisReference> getDiagnoses() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Behandlung)this.getEntity()).getDiagnoses().parallelStream().filter(d -> !d.isDeleted()).map(d -> ModelUtil.getAdapter((EntityWithId)d, IDiagnosisReference.class, true)).collect(Collectors.toList());
    }

    public void addDiagnosis(IDiagnosis diagnosis) {
        IDiagnosisReference diagnosisRef = null;
        diagnosisRef = diagnosis instanceof IDiagnosisReference ? (IDiagnosisReference)diagnosis : ModelUtil.getOrCreateDiagnosisReference(diagnosis);
        Diagnosis diag = (Diagnosis)((AbstractIdModelAdapter)diagnosisRef).getEntity();
        if (!((Behandlung)this.getEntity()).getDiagnoses().contains(diag)) {
            ((Behandlung)this.getEntityMarkDirty()).getDiagnoses().add(diag);
        }
        this.addUpdated((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DIAGNOSES);
        CodeElementServiceHolder.updateStatistics((Object)diagnosis, (IContact)ContextServiceHolder.get().getActiveUserContact().orElse(null));
        CodeElementServiceHolder.updateStatistics((Object)diagnosis, (IContact)this.getPatient());
    }

    public void removeDiagnosis(IDiagnosis diagnosis) {
        if (!(diagnosis instanceof IDiagnosisReference)) {
            LoggerFactory.getLogger(this.getClass()).warn("Can only remove IDiagnosisReference");
            return;
        }
        Diagnosis diag = (Diagnosis)((AbstractIdModelAdapter)diagnosis).getEntity();
        ((Behandlung)this.getEntityMarkDirty()).getDiagnoses().remove(diag);
        this.addUpdated((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DIAGNOSES);
    }

    public IInvoice getInvoice() {
        return ModelUtil.getAdapter((EntityWithId)((Behandlung)this.getEntity()).getInvoice(), IInvoice.class);
    }

    public void setInvoice(IInvoice value) {
        if (this.getInvoice() != null) {
            this.addRefresh((Identifiable)this.getInvoice());
        }
        if (value != null) {
            ((Behandlung)this.getEntityMarkDirty()).setInvoice((Invoice)((AbstractIdModelAdapter)value).getEntity());
            this.addRefresh((Identifiable)value);
        } else {
            ((Behandlung)this.getEntityMarkDirty()).setInvoice(null);
        }
    }

    public boolean isBillable() {
        return ((Behandlung)this.getEntity()).getBillable();
    }

    public void setBillable(boolean value) {
        ((Behandlung)this.getEntityMarkDirty()).setBillable(value);
    }

    public InvoiceState getInvoiceState() {
        IInvoice invoice = this.getInvoice();
        if (invoice != null) {
            return invoice.getState();
        }
        IMandator mandator = this.getMandator();
        IMandator activeMandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        if (mandator != null && activeMandator != null && mandator.equals(activeMandator)) {
            if (this.getDate().isEqual(LocalDate.now())) {
                return InvoiceState.FROM_TODAY;
            }
            return InvoiceState.NOT_FROM_TODAY;
        }
        return InvoiceState.NOT_FROM_YOU;
    }

    public String getLabel() {
        StringBuffer ret = new StringBuffer();
        IMandator m = this.getMandator();
        ret.append(TimeUtil.formatSafe((LocalDateTime)this.getTimeStamp()));
        ret.append(" (" + this.getInvoiceStateText() + ") - ");
        ret.append(m == null ? "?" : m.getLabel());
        return ret.toString();
    }

    private String getInvoiceStateText() {
        Object statusText = "";
        IInvoice rechnung = this.getInvoice();
        if (rechnung != null) {
            statusText = (String)statusText + "RG " + rechnung.getNumber() + ": ";
        }
        statusText = (String)statusText + this.getInvoiceState().getLocaleText();
        return statusText;
    }

    public String getHeadVersionInPlaintext() {
        String head = this.getVersionedEntry().getHead();
        if (head != null) {
            if (head.startsWith("<")) {
                Samdas samdas = new Samdas(head);
                String recordText = samdas.getRecordText();
                recordText = this.maskHTML(recordText);
                return recordText;
            }
            return head.trim();
        }
        return "";
    }

    private String maskHTML(String input) {
        String s = input.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("&", "&amp;");
        return s;
    }
}

