/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.service;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.types.Country;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoreQueryTest {
    private IModelService modelService;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.clearContacts();
        this.clearCoverages();
    }

    @After
    public void after() {
        this.clearContacts();
        this.clearCoverages();
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void queryExecute() {
        IQuery query = this.modelService.getQuery(IContact.class);
        Assert.assertNotNull((Object)query);
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void queryExecuteSingleResult() {
        IContact contact1 = this.createContact("McCloud", "Connor");
        IContact contact2 = this.createContact("McCloud", "Connor");
        IQuery query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.EQUALS, (Object)"McCloud");
        Optional singleResult = query.executeSingleResult();
        Assert.assertEquals((Object)contact1, singleResult.get());
        this.modelService.remove((Identifiable)contact1);
        this.modelService.remove((Identifiable)contact2);
    }

    @Test
    public void queryDeleted() {
        this.createContact("test1", "test1");
        IContact contact2 = this.createContact("test2", "test2");
        this.modelService.delete((Deleteable)contact2);
        this.createContact("test3", "test3");
        IQuery query = this.modelService.getQuery(IContact.class);
        Assert.assertNotNull((Object)query);
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
        query = this.modelService.getQuery(IContact.class, true);
        Assert.assertNotNull((Object)query);
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void queryGroups() {
        this.createContact("test1", "test1");
        IContact contact2 = this.createContact("test2", "test2");
        this.modelService.delete((Deleteable)contact2);
        this.createContact("test3", "test3");
        IQuery query = this.modelService.getQuery(IContact.class);
        Assert.assertNotNull((Object)query);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"test%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.EQUALS, (Object)"nonexisting");
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"test%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.EQUALS, (Object)"nonexisting");
        query.andJoinGroups();
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
        query = this.modelService.getQuery(IContact.class, true);
        Assert.assertNotNull((Object)query);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"test%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.EQUALS, (Object)"nonexisting");
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"test%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.EQUALS, (Object)"nonexisting");
        query.orJoinGroups();
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void findAll() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        List contacts = this.modelService.findAll(IContact.class);
        Assert.assertEquals((long)2L, (long)contacts.size());
    }

    @Test
    public void findAllById() {
        IContact iContact1 = this.createContact("test1", "test1");
        IContact iContact2 = this.createContact("test2", "test2");
        IContact iContact3 = this.createContact("test3", "test3");
        Assert.assertEquals((long)1L, (long)this.modelService.findAllById(Arrays.asList(iContact1.getId()), IContact.class).size());
        Assert.assertEquals((long)2L, (long)this.modelService.findAllById(Arrays.asList(iContact1.getId(), iContact2.getId()), IContact.class).size());
        Assert.assertEquals((long)3L, (long)this.modelService.findAllById(Arrays.asList(iContact1.getId(), iContact2.getId(), iContact3.getId()), IContact.class).size());
        Assert.assertEquals((long)0L, (long)this.modelService.findAllById(new ArrayList(), IContact.class).size());
    }

    @Test
    public void queryComplexWithIN() {
        IContact iContact1 = this.createContact("test1", "test1");
        IContact iContact2 = this.createContact("test2", "test2");
        IContact iContact3 = this.createContact("test3", "test2");
        iContact1.setCountry(Country.CH);
        iContact1.setPatient(true);
        iContact2.setCountry(Country.AT);
        iContact3.setCountry(Country.DE);
        this.modelService.save((Identifiable)iContact1);
        this.modelService.save((Identifiable)iContact2);
        this.modelService.save((Identifiable)iContact3);
        IQuery query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.IN, Arrays.asList("test1", "test3"));
        Assert.assertEquals((long)2L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.IN, Arrays.asList("Test1", "Test3"));
        Assert.assertEquals((long)0L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.IN, Arrays.asList("test2", "xy"));
        Assert.assertEquals((long)2L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.IN, Arrays.asList("test1", "test2", "test3"));
        Assert.assertEquals((long)3L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.IN, Arrays.asList("test1", "test2", "test3"));
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.EQUALS, (Object)"test2");
        List results = query.execute();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)iContact2.getId(), (Object)((IContact)results.get(0)).getId());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__COUNTRY, IQuery.COMPARATOR.IN, Arrays.asList(Country.CH, Country.AT));
        Assert.assertEquals((long)2L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__COUNTRY, IQuery.COMPARATOR.IN, Arrays.asList(Country.CH, Country.AT, Country.DE, Country.US));
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)true);
        results = query.execute();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)iContact1.getId(), (Object)((IContact)results.get(0)).getId());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__COUNTRY, IQuery.COMPARATOR.IN, Arrays.asList(Country.CH, Country.AT, Country.DE, Country.US));
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)true);
        results = query.execute();
        Assert.assertEquals((long)3L, (long)results.size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.IN, Arrays.asList("x", "y", "z"));
        Assert.assertEquals((long)0L, (long)query.execute().size());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__COUNTRY, IQuery.COMPARATOR.IN, new ArrayList());
        Assert.assertEquals((long)0L, (long)query.execute().size());
    }

    @Test
    public void queryContact() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        IQuery query = this.modelService.getQuery(IContact.class);
        Assert.assertNotNull((Object)query);
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void queryContactDescription() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        IQuery query = this.modelService.getQuery(IContact.class);
        Assert.assertNotNull((Object)query);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.EQUALS, (Object)"test1");
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"test1", (Object)((IContact)results.get(0)).getDescription1());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION3, IQuery.COMPARATOR.EQUALS, null);
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void queryPatient() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        this.createPatient("patient1", "patient1", LocalDate.of(1999, 1, 1));
        this.createPatient("patient2", "patient2", LocalDate.of(1999, 2, 2));
        IQuery query = this.modelService.getQuery(IPatient.class);
        Assert.assertNotNull((Object)query);
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void queryPatientNameAndDate() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        this.createPatient("patient1", "patient1", LocalDate.of(1999, 1, 1));
        this.createPatient("patient2", "patient2", LocalDate.of(1999, 2, 2));
        this.createPatient("patient2", "patient2", LocalDate.of(1999, 12, 12));
        IQuery query = this.modelService.getQuery(IPatient.class);
        Assert.assertNotNull((Object)query);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.EQUALS, (Object)"patient1");
        List results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"patient1", (Object)((IPatient)results.get(0)).getFirstName());
        query = this.modelService.getQuery(IPatient.class);
        Assert.assertNotNull((Object)query);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)LocalDate.of(1999, 1, 1));
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)LocalDate.of(1999, 1, 1), (Object)((IPatient)results.get(0)).getDateOfBirth().toLocalDate());
        query = this.modelService.getQuery(IPatient.class);
        Assert.assertNotNull((Object)query);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.EQUALS, (Object)"patient2");
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)LocalDate.of(1999, 2, 2));
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"patient2", (Object)((IPatient)results.get(0)).getFirstName());
        Assert.assertEquals((Object)LocalDate.of(1999, 2, 2), (Object)((IPatient)results.get(0)).getDateOfBirth().toLocalDate());
        query = this.modelService.getQuery(IPatient.class);
        Assert.assertNotNull((Object)query);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.of(1999, 2, 2));
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.LESS, (Object)LocalDate.of(1999, 12, 12));
        results = query.execute();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"patient2", (Object)((IPatient)results.get(0)).getFirstName());
        Assert.assertEquals((Object)LocalDate.of(1999, 2, 2), (Object)((IPatient)results.get(0)).getDateOfBirth().toLocalDate());
    }

    @Test
    public void queryNativeDistinctQuery() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        String nativeQuery = "SELECT DISTINCT BEZEICHNUNG1 FROM KONTAKT";
        List collect = this.modelService.executeNativeQuery(nativeQuery).collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList("test1", "test2"), collect);
    }

    @Test
    public void queryOrderByAndLastupdate() throws InterruptedException {
        this.createContact("test1", "test1");
        Thread.sleep(50L);
        IContact createContact = this.createContact("test2", "test2");
        long currentTimeMillis = createContact.getLastupdate();
        this.createContact("test3", "test3");
        this.createContact("test4", "test4");
        IQuery query = this.modelService.getQuery(IContact.class);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.ORDER.ASC);
        List ordered = query.execute();
        Assert.assertEquals((Object)"test1", (Object)((IContact)ordered.get(0)).getDescription1());
        Assert.assertEquals((Object)"test1", (Object)((IContact)query.executeAsCursor().next()).getDescription1());
        query = this.modelService.getQuery(IContact.class);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.ORDER.DESC);
        ordered = query.execute();
        Assert.assertEquals((Object)"test4", (Object)((IContact)ordered.get(0)).getDescription1());
        Assert.assertEquals((Object)"test4", (Object)((IContact)query.executeAsCursor().next()).getDescription1());
        query = this.modelService.getQuery(IContact.class);
        HashMap<String, Integer> caseContext = new HashMap<String, Integer>();
        caseContext.put("when|description2|equals|test3", 1);
        caseContext.put("otherwise", 2);
        query.orderBy(caseContext, IQuery.ORDER.ASC);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.ORDER.DESC);
        ordered = query.execute();
        Assert.assertEquals((Object)"test3", (Object)((IContact)ordered.get(0)).getDescription1());
        Assert.assertEquals((Object)"test4", (Object)((IContact)ordered.get(1)).getDescription1());
        Assert.assertEquals((Object)"test2", (Object)((IContact)ordered.get(2)).getDescription1());
        query = this.modelService.getQuery(IContact.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)currentTimeMillis);
        List execute = query.execute();
        Assert.assertEquals((long)3L, (long)execute.size());
    }

    @Test
    public void limitAndOffset() {
        this.createContact("test1", "test1");
        IContact test2 = this.createContact("test2", "test2");
        IContact test3 = this.createContact("test3", "test3");
        this.createContact("test4", "test4");
        IQuery query = this.modelService.getQuery(IContact.class);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.ORDER.ASC);
        query.offset(1);
        query.limit(2);
        List execute = query.execute();
        Assert.assertEquals((long)2L, (long)execute.size());
        Assert.assertEquals((Object)test2, execute.get(0));
        Assert.assertEquals((Object)test3, execute.get(1));
    }

    @Test
    public void subQueryTest() {
        IPatient patient1 = this.createPatient("patient1", "patient1", LocalDate.of(1999, 1, 1));
        IPatient patient2 = this.createPatient("patient2", "patient2", LocalDate.of(1999, 2, 2));
        this.createPatient("patient3", "patient3", LocalDate.of(1999, 12, 12));
        ICoverage coverage1 = this.createCoverage(patient1, "patient1");
        ICoverage coverage2 = this.createCoverage(patient2, "patient2");
        IQuery query = this.modelService.getQuery(IPatient.class);
        ISubQuery subQuery = query.createSubQuery(ICoverage.class, this.modelService);
        subQuery.andParentCompare("description1", IQuery.COMPARATOR.EQUALS, "bezeichnung");
        query.exists(subQuery);
        List results = query.execute();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(patient1));
        Assert.assertTrue((boolean)results.contains(patient2));
        this.modelService.remove((Identifiable)coverage2);
        results = query.execute();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(patient1));
        Assert.assertFalse((boolean)results.contains(patient2));
    }

    @Test
    public void compareExecuteCursorQuery() {
        this.createContact("test1", "test1");
        this.createContact("test2", "test2");
        this.createPatient("patient1", "patient1", LocalDate.of(1999, 1, 1));
        this.createPatient("patient2", "patient2", LocalDate.of(1999, 2, 2));
        this.createPatient("patient2", "patient2", LocalDate.of(1999, 12, 12));
        List executeList = this.modelService.getQuery(IPatient.class).execute();
        ArrayList cursorList = new ArrayList();
        this.modelService.getQuery(IPatient.class).executeAsCursor().forEachRemaining(p -> {
            boolean bl = cursorList.add(p);
        });
        Assert.assertTrue((executeList.size() == cursorList.size() && executeList.containsAll(cursorList) && cursorList.containsAll(executeList) ? 1 : 0) != 0);
    }

    @Test
    public void compareExecuteCursorQueryWithLazyBlob() {
        IBlob blob = (IBlob)this.modelService.create(IBlob.class);
        byte[] b = new byte[100];
        new Random().nextBytes(b);
        blob.setId("testblobid");
        blob.setDate(LocalDate.now());
        blob.setContent(b);
        this.modelService.save((Identifiable)blob);
        List list = this.modelService.getQuery(IBlob.class).execute();
        Assert.assertEquals((long)1L, (long)list.size());
        IBlob iBlob = (IBlob)list.get(0);
        byte[] content = iBlob.getContent();
        Assert.assertArrayEquals((byte[])b, (byte[])content);
        Throwable throwable = null;
        Object var7_8 = null;
        try (IQueryCursor cursor = this.modelService.getQuery(IBlob.class).executeAsCursor(Collections.singletonMap("eclipselink.maintain-cache", "True"));){
            iBlob = (IBlob)cursor.next();
            content = iBlob.getContent();
            Assert.assertArrayEquals((byte[])b, (byte[])content);
            cursor.clear();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.modelService.remove((Identifiable)blob);
    }

    private void clearContacts() {
        IQuery query = this.modelService.getQuery(IContact.class, true);
        List results = query.execute();
        results.stream().forEach(c -> this.modelService.remove((Identifiable)c));
    }

    private void clearCoverages() {
        IQuery query = this.modelService.getQuery(ICoverage.class, true);
        List results = query.execute();
        results.stream().forEach(c -> this.modelService.remove((Identifiable)c));
    }

    private IContact createContact(String desc1, String desc2) {
        IContact contact = (IContact)this.modelService.create(IContact.class);
        Assert.assertNotNull((Object)contact);
        Assert.assertTrue((boolean)(contact instanceof IContact));
        contact.setDescription1(desc1);
        contact.setDescription2(desc2);
        this.modelService.save((Identifiable)contact);
        return contact;
    }

    private IPatient createPatient(String firstName, String lastName, LocalDate birthDate) {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        Assert.assertNotNull((Object)patient);
        Assert.assertTrue((boolean)(patient instanceof IPatient));
        patient.setPatient(true);
        patient.setLastName(lastName);
        patient.setFirstName(firstName);
        patient.setDateOfBirth(birthDate.atStartOfDay());
        this.modelService.save((Identifiable)patient);
        return patient;
    }

    private ICoverage createCoverage(IPatient patient, String coverageLabel) {
        ICoverage coverage = new ICoverageBuilder(this.modelService, patient, coverageLabel, "testReason", "testBillingSystem").buildAndSave();
        return coverage;
    }
}

