/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.Gender;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PersonTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createUserSetActiveInContext();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void modifyPerson() {
        this.person.setMaritalStatus(MaritalStatus.MARRIED);
        this.coreModelService.save((Identifiable)this.person);
        Assert.assertTrue((boolean)this.person.isPerson());
        Assert.assertFalse((boolean)this.person.isPatient());
        Assert.assertFalse((boolean)this.person.isMandator());
        Assert.assertFalse((boolean)this.person.isOrganization());
        Assert.assertFalse((boolean)this.person.isLaboratory());
        String id = this.person.getId();
        Assert.assertNotNull((Object)id);
        IPerson findById = (IPerson)this.coreModelService.load(id, IPerson.class).get();
        Assert.assertNotNull((Object)findById);
        Assert.assertEquals((Object)MaritalStatus.MARRIED, (Object)findById.getMaritalStatus());
    }

    @Test
    public void searchPersonByBirthDate() {
        IQuery query = this.coreModelService.getQuery(IPerson.class);
        Date theBirthDate = new GregorianCalendar(1979, 6, 26).getTime();
        LocalDate localDate = Instant.ofEpochMilli(theBirthDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)localDate);
        List execute = query.execute();
        Assert.assertEquals((long)1L, (long)execute.size());
    }

    @Test
    public void personGetPostalAddressNonPersisted() {
        IPatient patient = (IPatient)new IContactBuilder.PatientBuilder(CoreModelServiceHolder.get(), "Firstname", "Lastname", LocalDate.of(2000, 1, 1), Gender.MALE).build();
        patient.setCity("City");
        patient.setZip("123");
        patient.setStreet("Street");
        String address = patient.getPostalAddress();
        Assert.assertNotNull((Object)address);
    }
}

