/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.test.AbstractTest;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSignatureTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createPatient();
        this.createMandator();
        this.createLocalArticle();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        IArticleDefaultSignature defaultSignature = (IArticleDefaultSignature)this.coreModelService.create(IArticleDefaultSignature.class);
        Assert.assertNotNull((Object)defaultSignature);
        Assert.assertTrue((boolean)(defaultSignature instanceof IArticleDefaultSignature));
        defaultSignature.setArticle(this.localArticle);
        defaultSignature.setDisposalType(EntryType.FIXED_MEDICATION);
        defaultSignature.setMorning("1");
        defaultSignature.setEvening("1");
        this.coreModelService.save((Identifiable)defaultSignature);
        Optional loaded = this.coreModelService.load(defaultSignature.getId(), IArticleDefaultSignature.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((defaultSignature == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)defaultSignature, loaded.get());
        Assert.assertEquals((Object)defaultSignature.getMorning(), (Object)((IArticleDefaultSignature)loaded.get()).getMorning());
        Assert.assertEquals((Object)defaultSignature.getNoon(), (Object)((IArticleDefaultSignature)loaded.get()).getNoon());
        Assert.assertEquals((Object)defaultSignature.getDisposalType(), (Object)((IArticleDefaultSignature)loaded.get()).getDisposalType());
        Assert.assertEquals((Object)"1-0-1-0", (Object)((IArticleDefaultSignature)loaded.get()).getSignatureAsDosisString());
        this.coreModelService.remove((Identifiable)defaultSignature);
    }
}

