/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppointmentTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createPatient();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createFindDelete() {
        LocalDateTime begin = LocalDateTime.of(2018, 9, 24, 13, 23);
        LocalDateTime end = begin.plus(Duration.ofMinutes(15L));
        IAppointment appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
        appointment.setReason("reason");
        appointment.setStartTime(begin);
        appointment.setEndTime(end);
        appointment.setState("geplant");
        appointment.setType("gesperrt");
        appointment.setSchedule("Notfall");
        appointment.setSubjectOrPatient(this.patient.getId());
        appointment.setTreatmentReason(1);
        appointment.setCaseType(2);
        appointment.setInsuranceType(3);
        this.coreModelService.save((Identifiable)appointment);
        IQuery query = this.coreModelService.getQuery(IAppointment.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__REASON, IQuery.COMPARATOR.EQUALS, (Object)"reason");
        IAppointment stored = (IAppointment)query.executeSingleResult().get();
        Assert.assertEquals((Object)begin, (Object)stored.getStartTime());
        Assert.assertEquals((Object)end, (Object)stored.getEndTime());
        Assert.assertEquals((Object)this.patient.getLabel(), (Object)stored.getSubjectOrPatient());
        Assert.assertEquals((long)15L, (long)stored.getDurationMinutes().intValue());
        Assert.assertEquals((Object)"geplant", (Object)stored.getState());
        Assert.assertEquals((Object)"gesperrt", (Object)stored.getType());
        Assert.assertEquals((Object)"Notfall", (Object)stored.getSchedule());
        Assert.assertEquals((long)1L, (long)stored.getTreatmentReason());
        Assert.assertEquals((long)2L, (long)stored.getCaseType());
        Assert.assertEquals((long)3L, (long)stored.getInsuranceType());
        this.coreModelService.remove((Identifiable)appointment);
    }

    @Test
    public void createQueryDelete() {
        LocalDateTime begin = LocalDateTime.of(2018, 9, 24, 13, 23);
        LocalDateTime end = begin.plus(Duration.ofMinutes(15L));
        IAppointment appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
        appointment.setReason("reason");
        appointment.setStartTime(begin);
        appointment.setEndTime(end);
        appointment.setState("geplant");
        appointment.setType("gesperrt");
        appointment.setSchedule("Notfall");
        appointment.setSubjectOrPatient(this.patient.getId());
        this.coreModelService.save((Identifiable)appointment);
        IQuery query = this.coreModelService.getQuery(IAppointment.class);
        query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)begin.toLocalDate());
        Assert.assertNotNull(query.executeSingleResult().orElse(null));
        query = this.coreModelService.getQuery(IAppointment.class);
        query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)begin.plusDays(1L).toLocalDate());
        Assert.assertNull(query.executeSingleResult().orElse(null));
        this.coreModelService.remove((Identifiable)appointment);
    }

    @Test
    public void setStateIncludesStateHistory() {
        LocalDateTime begin = LocalDateTime.of(2018, 9, 24, 13, 23);
        LocalDateTime end = begin.plus(Duration.ofMinutes(15L));
        IAppointment appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
        appointment.setReason("reason");
        appointment.setStartTime(begin);
        appointment.setEndTime(end);
        appointment.setState("started");
        this.coreModelService.save((Identifiable)appointment);
        Assert.assertTrue((boolean)appointment.getStateHistory().contains("started"));
        appointment.setState("modified");
        this.coreModelService.save((Identifiable)appointment);
        Assert.assertTrue((boolean)appointment.getStateHistory().contains("started"));
        Assert.assertTrue((boolean)appointment.getStateHistory().contains("modified"));
        this.coreModelService.remove((Identifiable)appointment);
    }

    @Test
    public void allDayAppointment() {
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        IAppointment appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
        appointment.setReason("allDay");
        appointment.setStartTime(startOfDay);
        appointment.setEndTime(null);
        this.coreModelService.save((Identifiable)appointment);
        Assert.assertTrue((boolean)appointment.isAllDay());
        Assert.assertNull((Object)appointment.getDurationMinutes());
        appointment.setEndTime(LocalDate.now().atStartOfDay().plusMinutes(25L));
        this.coreModelService.save((Identifiable)appointment);
        Assert.assertFalse((boolean)appointment.isAllDay());
        Assert.assertEquals((Object)25, (Object)appointment.getDurationMinutes());
        this.coreModelService.remove((Identifiable)appointment);
    }

    @Test
    public void lockUnlockAppointment() {
        LocalDateTime begin = LocalDateTime.of(2025, 10, 7, 10, 0);
        LocalDateTime end = begin.plus(Duration.ofMinutes(30L));
        IAppointment appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
        appointment.setReason("lockTest");
        appointment.setStartTime(begin);
        appointment.setEndTime(end);
        appointment.setState("geplant");
        this.coreModelService.save((Identifiable)appointment);
        Assert.assertFalse((boolean)appointment.isLocked());
        appointment.setLocked(true);
        this.coreModelService.save((Identifiable)appointment);
        IAppointment reloaded = (IAppointment)this.coreModelService.load(appointment.getId(), IAppointment.class).get();
        Assert.assertTrue((String)"Appointment sollte gesperrt sein", (boolean)reloaded.isLocked());
        reloaded.setLocked(false);
        this.coreModelService.save((Identifiable)reloaded);
        IAppointment unlocked = (IAppointment)this.coreModelService.load(appointment.getId(), IAppointment.class).get();
        Assert.assertFalse((String)"Appointment sollte nicht mehr gesperrt sein", (boolean)unlocked.isLocked());
        this.coreModelService.remove((Identifiable)appointment);
    }
}

