/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.test.AbstractTest;
import java.time.LocalDateTime;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecipeTest
extends AbstractTest {
    private IPrescription prescription;

    @Before
    public void before() {
        super.before();
        this.createPatient();
        this.createMandator();
        this.createLocalArticle();
        this.prescription = (IPrescription)new IPrescriptionBuilder(this.coreModelService, null, this.localArticle, this.patient, "1-0-0-1").buildAndSave();
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.prescription);
        super.after();
    }

    @Test
    public void create() {
        IRecipe recipe = (IRecipe)this.coreModelService.create(IRecipe.class);
        Assert.assertNotNull((Object)recipe);
        Assert.assertTrue((boolean)(recipe instanceof IRecipe));
        recipe.setDate(LocalDateTime.of(2000, 2, 2, 0, 0));
        recipe.setPatient(this.patient);
        recipe.setMandator(this.mandator);
        this.coreModelService.save((Identifiable)recipe);
        Optional loaded = this.coreModelService.load(recipe.getId(), IRecipe.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((recipe == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)recipe, loaded.get());
        Assert.assertEquals((Object)recipe.getPatient(), (Object)((IRecipe)loaded.get()).getPatient());
        Assert.assertEquals((Object)recipe.getMandator(), (Object)((IRecipe)loaded.get()).getMandator());
        Assert.assertEquals((Object)recipe.getDate(), (Object)((IRecipe)loaded.get()).getDate());
        Assert.assertEquals((Object)LocalDateTime.of(2000, 2, 2, 0, 0), (Object)((IRecipe)loaded.get()).getDate());
        this.coreModelService.remove((Identifiable)recipe);
    }

    @Test
    public void prescriptions() {
        IRecipe recipe = (IRecipe)this.coreModelService.create(IRecipe.class);
        Assert.assertNotNull((Object)recipe);
        Assert.assertTrue((boolean)(recipe instanceof IRecipe));
        recipe.setDate(LocalDateTime.of(2000, 2, 2, 0, 0));
        recipe.setPatient(this.patient);
        recipe.setMandator(this.mandator);
        this.coreModelService.save((Identifiable)recipe);
        Assert.assertTrue((boolean)recipe.getPrescriptions().isEmpty());
        this.prescription.setEntryType(EntryType.RECIPE);
        this.prescription.setRecipe(recipe);
        this.coreModelService.save((Identifiable)this.prescription);
        Assert.assertFalse((boolean)recipe.getPrescriptions().isEmpty());
        recipe.removePrescription(this.prescription);
        Assert.assertTrue((boolean)recipe.getPrescriptions().isEmpty());
        this.coreModelService.remove((Identifiable)recipe);
    }
}

