/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IAddress;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.AddressType;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.RelationshipType;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContactTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createPerson();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createAndRemoveIContact() throws InstantiationException, IllegalAccessException {
        Assert.assertNotNull((Object)this.person.getId());
        Assert.assertTrue((boolean)this.person.isPerson());
        Assert.assertFalse((boolean)this.person.isPatient());
        Assert.assertFalse((boolean)this.person.isMandator());
        Assert.assertFalse((boolean)this.person.isOrganization());
        Assert.assertFalse((boolean)this.person.isLaboratory());
    }

    @Test
    public void getAgeInYears() {
        IPerson findById = (IPerson)this.coreModelService.load(this.person.getId(), IPerson.class).get();
        Assert.assertEquals((Object)this.person.getId(), (Object)findById.getId());
        Assert.assertEquals((Object)LocalDate.of(1979, 7, 26), (Object)this.person.getDateOfBirth().toLocalDate());
        int ageInYears = findById.getAgeInYears();
        Assert.assertTrue((ageInYears >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void createRemoveAddress() {
        IAddress nursingHome = (IAddress)this.coreModelService.create(IAddress.class);
        nursingHome.setType(AddressType.NURSING_HOME);
        nursingHome.setStreet2("Street2");
        nursingHome.setZip("6840");
        nursingHome.setCountry(Country.AT);
        nursingHome.setContact((IContact)this.person);
        this.coreModelService.save(Arrays.asList(this.person, nursingHome));
        Assert.assertTrue((boolean)this.person.getAddress().contains(nursingHome));
        this.coreModelService.delete((Deleteable)nursingHome);
        Assert.assertFalse((boolean)this.person.getAddress().contains(nursingHome));
    }

    @Test
    public void createUpdateRemoveContactImage() throws IOException {
        IImage image = (IImage)CoreModelServiceHolder.get().create(IImage.class);
        image.setDate(LocalDate.now());
        image.setTitle("RandomImage");
        image.setMimeType(MimeType.png);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("./elexis.png");){
            byte[] byteArray = IOUtils.toByteArray((InputStream)is);
            image.setImage(byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.person.setImage(image);
        IPerson findById = (IPerson)this.coreModelService.load(this.person.getId(), IPerson.class).get();
        IImage _image = findById.getImage();
        Assert.assertTrue((boolean)Arrays.equals(image.getImage(), _image.getImage()));
        Assert.assertEquals((Object)MimeType.png, (Object)_image.getMimeType());
        this.coreModelService.delete((Deleteable)image);
        this.person.setImage(null);
        Assert.assertNull((Object)this.person.getImage());
        this.person.setImage(image);
        Assert.assertNotNull((Object)this.person.getImage().getImage());
    }

    @Test
    public void createWithDefaultAddress() {
        IOrganization employer = (IOrganization)new IContactBuilder.OrganizationBuilder(this.coreModelService, "MEDEVIT").defaultAddress("street", "zip", "city", Country.NDF).buildAndSave();
        Assert.assertNotNull((Object)employer);
        Assert.assertFalse((boolean)employer.getAddress().isEmpty());
    }

    @Test
    public void getSetProperties() {
        this.person.setEmail("email@tst.tst");
        this.person.setEmail2("email2@tst.tst");
        this.coreModelService.save((Identifiable)this.person);
        Assert.assertEquals((Object)"email@tst.tst", (Object)this.person.getEmail());
        Assert.assertEquals((Object)"email2@tst.tst", (Object)this.person.getEmail2());
    }

    @Test
    public void createRemoveRelatedContact() {
        IOrganization employer = (IOrganization)new IContactBuilder.OrganizationBuilder(this.coreModelService, "MEDEVIT").buildAndSave();
        IPerson findById = (IPerson)this.coreModelService.load(this.person.getId(), IPerson.class).get();
        IRelatedContact relatedContact = (IRelatedContact)this.coreModelService.create(IRelatedContact.class);
        relatedContact.setOtherContact((IContact)employer);
        relatedContact.setMyType(RelationshipType.BUSINESS_EMPLOYEE);
        relatedContact.setOtherType(RelationshipType.BUSINESS_EMPLOYER);
        relatedContact.setRelationshipDescription("blabla");
        relatedContact.setMyContact((IContact)findById);
        this.coreModelService.save((Identifiable)relatedContact);
        IRelatedContact iRelatedContact = (IRelatedContact)findById.getRelatedContacts().get(0);
        Assert.assertEquals((Object)relatedContact.getId(), (Object)iRelatedContact.getId());
        Assert.assertEquals((Object)employer.getId(), (Object)iRelatedContact.getOtherContact().getId());
        Assert.assertEquals((Object)RelationshipType.BUSINESS_EMPLOYEE, (Object)iRelatedContact.getMyType());
        Assert.assertEquals((Object)RelationshipType.BUSINESS_EMPLOYER, (Object)iRelatedContact.getOtherType());
        Assert.assertEquals((Object)"blabla", (Object)iRelatedContact.getRelationshipDescription());
        this.coreModelService.delete((Deleteable)relatedContact);
        Assert.assertFalse((boolean)findById.getRelatedContacts().contains(relatedContact));
    }

    @Test
    public void extInfo() {
        IPerson testPerson = (IPerson)new IContactBuilder.PersonBuilder(this.coreModelService, "firstname", "lastname", LocalDate.of(2000, 1, 1), Gender.FEMALE).buildAndSave();
        Assert.assertTrue((testPerson.getExtInfo((Object)"testKey") == null ? 1 : 0) != 0);
        testPerson.setExtInfo((Object)"testKey", (Object)"testValue");
        this.coreModelService.save((Identifiable)testPerson);
        Optional loaded = this.coreModelService.load(testPerson.getId(), IPerson.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertEquals((Object)"testValue", (Object)((IPerson)loaded.get()).getExtInfo((Object)"testKey"));
        this.coreModelService.remove((Identifiable)testPerson);
    }
}

