/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StockTest {
    private IModelService modelService;
    private IArticle article;
    private IArticle article1;
    private IStock stock;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.article = (IArticle)this.modelService.create(IArticle.class);
        this.article.setName("test article");
        this.article.setCode("123456789");
        this.article.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article.setGtin("0000001111111");
        this.article.setPackageSize(12);
        this.article.setSellingSize(12);
        this.modelService.save((Identifiable)this.article);
        this.article1 = (IArticle)this.modelService.create(IArticle.class);
        this.article1.setName("test article 1");
        this.article1.setCode("987654321");
        this.article1.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article1.setGtin("1111112222222");
        this.article1.setPackageSize(24);
        this.article1.setSellingSize(24);
        this.modelService.save((Identifiable)this.article1);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.article);
        this.modelService.remove((Identifiable)this.article1);
        this.modelService.remove((Identifiable)this.stock);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        this.stock = (IStock)this.modelService.create(IStock.class);
        Assert.assertNotNull((Object)this.stock);
        Assert.assertTrue((boolean)(this.stock instanceof IStock));
        this.stock.setCode("code");
        this.stock.setDescription("description");
        this.modelService.save((Identifiable)this.stock);
        this.modelService.refresh((Identifiable)this.stock);
        Assert.assertNotNull((Object)this.stock.getId());
        Optional loaded = this.modelService.load(this.stock.getId(), IStock.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((this.stock == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.stock, loaded.get());
        Assert.assertEquals((Object)"code", (Object)this.stock.getCode());
        Assert.assertEquals((Object)"description", (Object)this.stock.getDescription());
    }

    @Test
    public void getStockEntries() {
        this.stock = (IStock)this.modelService.create(IStock.class);
        this.stock.setCode("TST2");
        this.stock.setPriority(5);
        this.modelService.save((Identifiable)this.stock);
        IStockEntry entry = (IStockEntry)this.modelService.create(IStockEntry.class);
        entry.setArticle(this.article);
        entry.setStock(this.stock);
        entry.setMinimumStock(2);
        entry.setCurrentStock(1);
        entry.setMaximumStock(5);
        this.modelService.save((Identifiable)entry);
        IStockEntry entry1 = (IStockEntry)this.modelService.create(IStockEntry.class);
        entry1.setArticle(this.article1);
        entry1.setStock(this.stock);
        entry1.setMinimumStock(3);
        entry1.setCurrentStock(2);
        entry1.setMaximumStock(4);
        this.modelService.save((Identifiable)entry1);
        IQuery query = this.modelService.getQuery(IStockEntry.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__STOCK, IQuery.COMPARATOR.EQUALS, (Object)this.stock);
        List execute = query.execute();
        Assert.assertEquals((long)2L, (long)execute.size());
        List stockEntries = this.stock.getStockEntries();
        Assert.assertEquals((long)2L, (long)stockEntries.size());
        this.modelService.remove((Identifiable)entry);
        this.modelService.remove((Identifiable)entry1);
    }
}

