/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.LabItemTyp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabResultTest
extends AbstractTest {
    private IPatient patient2;
    private ILabItem item1;

    @Before
    public void before() {
        super.before();
        super.createPatient();
        super.createUserSetActiveInContext();
        this.patient2 = (IPatient)this.coreModelService.create(IPatient.class);
        this.patient2.setDescription1("test patient 2");
        this.coreModelService.save((Identifiable)this.patient2);
        this.item1 = (ILabItem)this.coreModelService.create(ILabItem.class);
        this.item1.setCode("testItem");
        this.item1.setName("test item name");
        this.item1.setReferenceFemale("<25");
        this.item1.setReferenceMale("<30");
        this.item1.setTyp(LabItemTyp.NUMERIC);
        this.coreModelService.save((Identifiable)this.item1);
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.patient2);
        this.coreModelService.remove((Identifiable)this.item1);
        super.after();
    }

    @Test
    public void create() {
        ILabResult result = (ILabResult)this.coreModelService.create(ILabResult.class);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ILabResult));
        result.setPatient(this.patient);
        result.setItem(this.item1);
        result.setReferenceFemale("<25");
        result.setReferenceMale("<30");
        result.setResult("22.56");
        result.setExtInfo((Object)"testInfo", (Object)"testInfo");
        this.coreModelService.save((Identifiable)result);
        Optional loadedResult = this.coreModelService.load(result.getId(), ILabResult.class);
        Assert.assertTrue((boolean)loadedResult.isPresent());
        Assert.assertFalse((result == loadedResult.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)result, loadedResult.get());
        Assert.assertEquals((Object)result.getItem(), (Object)((ILabResult)loadedResult.get()).getItem());
        Assert.assertEquals((Object)result.getReferenceFemale(), (Object)((ILabResult)loadedResult.get()).getReferenceFemale());
        Assert.assertEquals((Object)result.getReferenceMale(), (Object)((ILabResult)loadedResult.get()).getReferenceMale());
        Assert.assertEquals((Object)result.getResult(), (Object)((ILabResult)loadedResult.get()).getResult());
        Assert.assertEquals((Object)result.getExtInfo((Object)"testInfo"), (Object)((ILabResult)loadedResult.get()).getExtInfo((Object)"testInfo"));
        this.coreModelService.remove((Identifiable)result);
    }

    @Test
    public void getReference() {
        ILabItem item = (ILabItem)this.coreModelService.create(ILabItem.class);
        item.setCode("testItemRef");
        item.setName("test item reference name");
        item.setTyp(LabItemTyp.NUMERIC);
        this.coreModelService.save((Identifiable)item);
        Assert.assertEquals((Object)"", (Object)item.getReferenceMale());
        Assert.assertEquals((Object)"", (Object)item.getReferenceFemale());
        ILabResult result = (ILabResult)this.coreModelService.create(ILabResult.class);
        result.setPatient(this.patient);
        result.setItem(item);
        result.setReferenceMale("<0.35");
        result.setResult("3.26");
        this.coreModelService.save((Identifiable)result);
        ConfigServiceHolder.setUser((String)"lab/localRefValues", (boolean)true);
        Assert.assertEquals((Object)"<0.35", (Object)result.getReferenceMale());
        item.setReferenceMale("<0.34");
        this.coreModelService.save((Identifiable)item);
        Assert.assertEquals((Object)"<0.34", (Object)result.getReferenceMale());
        ConfigServiceHolder.setUser((String)"lab/localRefValues", (boolean)false);
        Assert.assertEquals((Object)"<0.35", (Object)result.getReferenceMale());
        this.coreModelService.remove((Identifiable)result);
        this.coreModelService.remove((Identifiable)item);
    }

    @Test
    public void query() {
        ILabResult result1 = (ILabResult)this.coreModelService.create(ILabResult.class);
        result1.setPatient(this.patient);
        result1.setItem(this.item1);
        result1.setReferenceFemale("<25");
        result1.setReferenceMale("<30");
        result1.setResult("22.56");
        result1.setObservationTime(LocalDateTime.of(2018, 1, 1, 10, 0));
        this.coreModelService.save((Identifiable)result1);
        ILabResult result2 = (ILabResult)this.coreModelService.create(ILabResult.class);
        result2.setPatient(this.patient2);
        result2.setItem(this.item1);
        result2.setReferenceFemale("<25");
        result2.setReferenceMale("<30");
        result2.setResult("35.85");
        result2.setObservationTime(LocalDateTime.of(2018, 1, 2, 15, 0));
        this.coreModelService.save((Identifiable)result2);
        IQuery query = this.coreModelService.getQuery(ILabResult.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__ITEM, IQuery.COMPARATOR.EQUALS, (Object)this.item1);
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        query = this.coreModelService.getQuery(ILabResult.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertFalse((result1 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)result1, existing.get(0));
        query = this.coreModelService.getQuery(ILabResult.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient2);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__OBSERVATION_TIME, IQuery.COMPARATOR.GREATER, (Object)LocalDateTime.of(2018, 1, 2, 13, 0));
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertFalse((result2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)result2, existing.get(0));
        Assert.assertEquals((Object)result2.getObservationTime(), (Object)((ILabResult)existing.get(0)).getObservationTime());
        this.coreModelService.remove((Identifiable)result1);
        this.coreModelService.remove((Identifiable)result2);
    }
}

