/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IAccountTransactionBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.builder.IPaymentBuilder;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvoiceTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createEncounter();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        IInvoice invoice = (IInvoice)this.coreModelService.create(IInvoice.class);
        invoice.setCoverage(this.coverage);
        invoice.setDate(LocalDate.now());
        invoice.setDateFrom(LocalDate.now());
        invoice.setRemark("remark");
        this.coreModelService.save((Identifiable)invoice);
        Assert.assertTrue((Long.valueOf(invoice.getNumber()) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)invoice.getAttachments().size());
        IDocumentLetter document = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
        document.setAuthor((IContact)this.mandator);
        this.coreModelService.save((Identifiable)document);
        invoice.addAttachment((IDocument)document);
        Assert.assertEquals((long)1L, (long)invoice.getAttachments().size());
        invoice.removeAttachment((IDocument)invoice.getAttachments().get(0));
        Assert.assertEquals((long)0L, (long)invoice.getAttachments().size());
        this.coreModelService.remove((Identifiable)document);
        this.coreModelService.remove((Identifiable)invoice);
    }

    @Test
    public void getSortedEncounters() throws InterruptedException {
        IInvoice invoice = (IInvoice)this.coreModelService.create(IInvoice.class);
        invoice.setCoverage(this.coverage);
        invoice.setDate(LocalDate.now());
        invoice.setDateFrom(LocalDate.now());
        invoice.setRemark("remark");
        this.coreModelService.save((Identifiable)invoice);
        ArrayList<IEncounter> created = new ArrayList<IEncounter>();
        int i2 = 0;
        while (i2 < 10) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).build();
            encounter.setDate(LocalDate.now().minusDays(i2));
            encounter.setInvoice(invoice);
            this.coreModelService.save((Identifiable)encounter);
            created.add(encounter);
            ++i2;
        }
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).build();
        encounter.setDate(LocalDate.now().minusDays(1L));
        encounter.setInvoice(invoice);
        this.coreModelService.save((Identifiable)encounter);
        created.add(encounter);
        invoice = (IInvoice)this.coreModelService.load(invoice.getId(), IInvoice.class).get();
        List encounters = invoice.getEncounters();
        Assert.assertEquals((long)11L, (long)encounters.size());
        Assert.assertEquals((Object)LocalDate.now(), (Object)((IEncounter)encounters.get(10)).getDate());
        Assert.assertEquals((Object)((IEncounter)encounters.get(8)).getDate(), (Object)((IEncounter)encounters.get(9)).getDate());
        this.coreModelService.remove((Identifiable)invoice);
        created.forEach(i -> this.coreModelService.remove(i));
    }

    @Test
    public void multiThreadMappedProperties() throws InterruptedException {
        IInvoice invoice = (IInvoice)this.coreModelService.create(IInvoice.class);
        invoice.setCoverage(this.coverage);
        invoice.setDate(LocalDate.now());
        invoice.setDateFrom(LocalDate.now());
        invoice.setRemark("remark");
        this.coreModelService.save((Identifiable)invoice);
        ArrayList created = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(3);
        int i2 = 0;
        while (i2 < 100) {
            int number = i2++;
            executor.execute(() -> {
                IInvoiceBilled invoiceBilled = (IInvoiceBilled)this.coreModelService.create(IInvoiceBilled.class);
                invoiceBilled.setInvoice(invoice);
                this.coreModelService.save((Identifiable)invoiceBilled);
                created.add(invoiceBilled);
            });
            executor.execute(() -> {
                IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).build();
                encounter.setInvoice(invoice);
                this.coreModelService.save((Identifiable)encounter);
                created.add(encounter);
            });
            executor.execute(() -> {
                IPayment payment = (IPayment)new IPaymentBuilder(this.coreModelService, invoice, new Money(number), "test").buildAndSave();
                created.add(payment);
            });
            executor.execute(() -> {
                IAccountTransaction transaction = (IAccountTransaction)new IAccountTransactionBuilder(this.coreModelService, invoice, this.patient, new Money(number), LocalDate.now(), "test").buildAndSave();
                created.add(transaction);
            });
            executor.execute(() -> {
                invoice.setRemark("test " + number);
                this.coreModelService.save((Identifiable)invoice);
            });
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)100L, (long)invoice.getBilled().size());
        Assert.assertEquals((long)100L, (long)invoice.getEncounters().size());
        Assert.assertEquals((long)100L, (long)invoice.getPayments().size());
        Assert.assertEquals((long)100L, (long)invoice.getTransactions().size());
        Assert.assertTrue((boolean)invoice.getRemark().startsWith("test "));
        this.coreModelService.remove((Identifiable)invoice);
        created.forEach(i -> this.coreModelService.remove(i));
    }
}

