/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ch.BillingLaw;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class BillingLawTest {
    @Test
    public void testBillingNames() {
        Assert.assertEquals((Object)"KVG", (Object)BillingLaw.KVG.name());
        Assert.assertEquals((Object)"VVG", (Object)BillingLaw.VVG.name());
        Assert.assertEquals((Object)"privat", (Object)BillingLaw.privat.name());
        Assert.assertEquals((Object)"IV", (Object)BillingLaw.IV.name());
        Assert.assertEquals((Object)"MV", (Object)BillingLaw.MV.name());
        Assert.assertEquals((Object)"OTHER", (Object)BillingLaw.OTHER.name());
    }

    @Test
    public void testLocalizedBillingNames() {
        if (Locale.getDefault().toString().equals("de_CH")) {
            System.out.println("Billing law Locale german tests");
            Assert.assertTrue((boolean)BillingLaw.IV.getLocaleText().startsWith("IVG:"));
            Assert.assertTrue((boolean)BillingLaw.KVG.getLocaleText().startsWith("KVG:"));
            Assert.assertTrue((boolean)BillingLaw.MV.getLocaleText().startsWith("MVG:"));
            Assert.assertTrue((boolean)BillingLaw.VVG.getLocaleText().startsWith("VVG:"));
            Assert.assertTrue((boolean)BillingLaw.privat.getLocaleText().startsWith("privat"));
            Assert.assertTrue((boolean)BillingLaw.OTHER.getLocaleText().startsWith("Andere"));
            Assert.assertTrue((boolean)BillingLaw.NONE.getLocaleText().startsWith("Keine"));
        }
        if (Locale.getDefault().toString().equals("fr_CH")) {
            System.out.println("Billing law Locale french tests");
            Assert.assertTrue((boolean)BillingLaw.IV.getLocaleText().startsWith("LAI:"));
            Assert.assertTrue((boolean)BillingLaw.KVG.getLocaleText().startsWith("LAMal:"));
            Assert.assertTrue((boolean)BillingLaw.MV.getLocaleText().startsWith("LAM:"));
            Assert.assertTrue((boolean)BillingLaw.VVG.getLocaleText().startsWith("LCA:"));
            Assert.assertTrue((boolean)BillingLaw.privat.getLocaleText().startsWith("priv\u00e9"));
            Assert.assertTrue((boolean)BillingLaw.OTHER.getLocaleText().startsWith("Autre"));
            Assert.assertTrue((boolean)BillingLaw.NONE.getLocaleText().startsWith("Aucun"));
        }
    }
}

