/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.mail.IMailClient;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.internal.Messages;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

public class SendMailRunnable
implements IIdentifiedRunnable {
    public static final String RUNNABLE_ID = "sendMailFromContext";
    private IMailClient mailClient;

    public SendMailRunnable(IMailClient mailClient) {
        this.mailClient = mailClient;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return Messages.SendMailRunnable_1;
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        defaultRunContext.put("accountId", (Serializable)((Object)"missingRequired"));
        defaultRunContext.put("message", (Serializable)((Object)"missingRequired"));
        return defaultRunContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        String accountId = (String)((Object)runContext.get("accountId"));
        Serializable _message = runContext.get("message");
        MailMessage message = MailMessage.fromMap((Map)((Object)_message));
        Optional<MailAccount> account = this.mailClient.getAccount(accountId);
        if (message != null && account.isPresent() && !this.mailClient.sendMail(account.get(), message)) {
            throw new TaskException(6, "Send mail failed, see log for details");
        }
        return null;
    }
}

