/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.mail.IMAPMailMessage;
import ch.elexis.core.mail.IMailClient;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.internal.MailClientProperties;
import ch.elexis.core.services.IConfigService;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.Address;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.search.SearchTerm;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MailClient
implements IMailClient {
    private static final Logger logger = LoggerFactory.getLogger(MailClient.class);
    private static final String CONFIG_ACCOUNTS = "ch.elexis.core.mail/accounts";
    private static final String CONFIG_ACCOUNT = "ch.elexis.core.mail/account";
    private static final String ACCOUNTS_SEPARATOR = ",";
    @Reference
    private IConfigService configService;
    private IMailClient.ErrorTyp lastError;

    @Activate
    private void activate() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=org.eclipse.angus.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content- handler=org.eclipse.angus.mail.handlers.message_rfc822");
        mc.addMailcap("message/disposition-notification;;x-java-content-handler=org.eclipse.angus.mail.handlers.text_plain");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    @Override
    public Optional<IMailClient.ErrorTyp> getLastError() {
        IMailClient.ErrorTyp ret = this.lastError;
        this.lastError = null;
        return Optional.ofNullable(ret);
    }

    @Override
    public Optional<MailAccount> getAccount(String id) {
        MailAccount ret = null;
        String accountString = this.configService.getLocal("ch.elexis.core.mail/account/" + id, null);
        if (accountString == null) {
            accountString = this.configService.get("ch.elexis.core.mail/account/" + id, null);
        }
        if (accountString != null) {
            ret = MailAccount.from(accountString);
        }
        return Optional.ofNullable(ret);
    }

    @Override
    public List<String> getAccounts() {
        ArrayList<String> ret = new ArrayList<String>();
        String accountIds = this.configService.get(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            ret.addAll(Arrays.asList(currentIds));
        }
        return ret;
    }

    @Override
    public List<String> getAccountsLocal() {
        ArrayList<String> ret = new ArrayList<String>();
        String accountIds = this.configService.getLocal(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            ret.addAll(Arrays.asList(currentIds));
        }
        return ret;
    }

    @Override
    public void saveAccount(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.addAccountId(account.getId());
            this.configService.set("ch.elexis.core.mail/account/" + account.getId(), account.toString());
        }
    }

    @Override
    public void saveAccountLocal(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.addAccountIdLocal(account.getId());
            this.configService.setLocal("ch.elexis.core.mail/account/" + account.getId(), account.toString());
        }
    }

    private void addAccountIdLocal(String id) {
        if (id.contains(ACCOUNTS_SEPARATOR)) {
            throw new IllegalStateException("Id can not contain separator [,]");
        }
        String accountIds = this.configService.getLocal(CONFIG_ACCOUNTS, null);
        if (accountIds == null) {
            this.configService.setLocal(CONFIG_ACCOUNTS, id);
        } else {
            String[] currentIds;
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(id)) {
                    return;
                }
                ++n2;
            }
            this.configService.setLocal(CONFIG_ACCOUNTS, accountIds + ACCOUNTS_SEPARATOR + id);
        }
    }

    private void addAccountId(String id) {
        if (id.contains(ACCOUNTS_SEPARATOR)) {
            throw new IllegalStateException("Id can not contain separator [,]");
        }
        String accountIds = this.configService.get(CONFIG_ACCOUNTS, null);
        if (accountIds == null) {
            this.configService.set(CONFIG_ACCOUNTS, id);
        } else {
            String[] currentIds;
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(id)) {
                    return;
                }
                ++n2;
            }
            this.configService.set(CONFIG_ACCOUNTS, accountIds + ACCOUNTS_SEPARATOR + id);
        }
    }

    @Override
    public void removeAccount(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.removeAccountId(account.getId());
            this.configService.set("ch.elexis.core.mail/account/" + account.getId(), null);
        }
    }

    @Override
    public void removeAccountLocal(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.removeAccountIdLocal(account.getId());
            this.configService.setLocal("ch.elexis.core.mail/account/" + account.getId(), null);
        }
    }

    private void removeAccountIdLocal(String id) {
        String accountIds = this.configService.getLocal(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!string.equals(id)) {
                    if (sb.length() > 0) {
                        sb.append(ACCOUNTS_SEPARATOR);
                    }
                    sb.append(string);
                }
                ++n2;
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                this.configService.setLocal(CONFIG_ACCOUNTS, sb.toString());
            } else {
                this.configService.setLocal(CONFIG_ACCOUNTS, null);
            }
        }
    }

    private void removeAccountId(String id) {
        String accountIds = this.configService.get(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!string.equals(id)) {
                    if (sb.length() > 0) {
                        sb.append(ACCOUNTS_SEPARATOR);
                    }
                    sb.append(string);
                }
                ++n2;
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                this.configService.set(CONFIG_ACCOUNTS, sb.toString());
            } else {
                this.configService.set(CONFIG_ACCOUNTS, null);
            }
        }
    }

    @Override
    public boolean testAccount(final MailAccount account) {
        block5: {
            MailClientProperties properties = new MailClientProperties(account);
            try {
                if (account.getType() == MailAccount.TYPE.SMTP) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    Transport transport = session.getTransport();
                    transport.connect();
                    transport.close();
                    break block5;
                }
                if (account.getType() == MailAccount.TYPE.IMAP) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    Store store = session.getStore("imap");
                    store.connect();
                    store.close();
                    break block5;
                }
                if (account.getType() == MailAccount.TYPE.IMAPS) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    Store store = session.getStore("imaps");
                    store.connect();
                    store.close();
                    break block5;
                }
                logger.warn("Unknown account type [" + String.valueOf((Object)account.getType()) + "].");
                this.lastError = IMailClient.ErrorTyp.CONFIGTYP;
                return false;
            }
            catch (MessagingException e) {
                logger.warn("Error testing account [" + account.getId() + "]", (Throwable)e);
                this.lastError = IMailClient.ErrorTyp.CONNECTION;
                this.handleException(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean sendMail(final MailAccount account, MailMessage message) {
        block7: {
            System.setProperty("mail.mime.encodeparameters", "false");
            MailClientProperties properties = new MailClientProperties(account);
            try {
                if (account.getType() == MailAccount.TYPE.SMTP) {
                    FileDataSource source;
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    MimeMessage mimeMessage = new MimeMessage(session);
                    mimeMessage.addHeader("X-ElexisMail", "ch.elexis.core.mail");
                    mimeMessage.setFrom(account.getFromAddress());
                    mimeMessage.setSubject(message.getSubject());
                    MimeMultipart multipart = new MimeMultipart("related");
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setContent((Object)message.getHtmlText(), "text/html;charset=UTF-8");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    if (message.hasImage()) {
                        for (String imageString : message.getImageStrings()) {
                            File image = message.getImage(imageString);
                            if (image == null) continue;
                            messageBodyPart = new MimeBodyPart();
                            source = new FileDataSource(image);
                            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                            messageBodyPart.setHeader("Content-ID", "<" + message.getImageContentId(imageString) + ">");
                            messageBodyPart.setDisposition("inline");
                            messageBodyPart.setFileName(image.getName());
                            multipart.addBodyPart((BodyPart)messageBodyPart);
                        }
                    }
                    if (message.hasAttachments()) {
                        List<File> attachments = message.getAttachments();
                        for (File file : attachments) {
                            messageBodyPart = new MimeBodyPart();
                            source = new FileDataSource(file);
                            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                            messageBodyPart.setFileName(file.getName());
                            multipart.addBodyPart((BodyPart)messageBodyPart);
                        }
                    }
                    mimeMessage.setContent((Multipart)multipart);
                    Transport transport = session.getTransport();
                    transport.connect();
                    ArrayList<InternetAddress> addressesList = new ArrayList<InternetAddress>();
                    mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])message.getToAddress());
                    addressesList.addAll(Arrays.asList(message.getToAddress()));
                    mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])message.getCcAddress());
                    addressesList.addAll(Arrays.asList(message.getCcAddress()));
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(transport.getClass().getClassLoader());
                    transport.sendMessage((Message)mimeMessage, (Address[])addressesList.toArray(new InternetAddress[addressesList.size()]));
                    transport.close();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    break block7;
                }
                logger.warn("Invalid account type for sending [" + String.valueOf((Object)account.getType()) + "].");
                this.lastError = IMailClient.ErrorTyp.CONFIGTYP;
                return false;
            }
            catch (MessagingException e) {
                logger.warn("Error sending using account [" + account.getId() + "]", (Throwable)e);
                this.handleException(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<IMAPMailMessage> getMessages(MailAccount account, String sourceFolder, boolean flag, boolean onlyFetchUnflagged) throws MessagingException {
        if (account.getType() == MailAccount.TYPE.SMTP) {
            logger.warn("Invalid account type for receiving [" + String.valueOf((Object)account.getType()) + "].");
            this.lastError = IMailClient.ErrorTyp.CONFIGTYP;
            return Collections.emptyList();
        }
        if (sourceFolder == null) {
            sourceFolder = "INBOX";
        }
        IMAPStore imapStore = null;
        try {
            Message[] messages;
            imapStore = (IMAPStore)this.getSession(account).getStore();
            imapStore.connect();
            ArrayList<IMAPMailMessage> listMessages = new ArrayList<IMAPMailMessage>();
            Folder folder = imapStore.getFolder(sourceFolder);
            int openMode = flag ? 2 : 1;
            folder.open(openMode);
            Message[] messageArray = messages = folder.getMessages();
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message _message = messageArray[n2];
                if (!onlyFetchUnflagged || !_message.getFlags().contains(Flags.Flag.FLAGGED)) {
                    IMAPMailMessage selfSustainableCopy = IMAPMailMessage.of((IMAPMessage)_message);
                    listMessages.add(selfSustainableCopy);
                    if (flag) {
                        _message.setFlag(Flags.Flag.FLAGGED, true);
                    }
                }
                ++n2;
            }
            folder.close(false);
            ArrayList<IMAPMailMessage> arrayList = listMessages;
            return arrayList;
        }
        finally {
            if (imapStore != null && imapStore.isConnected()) {
                imapStore.close();
            }
        }
    }

    private Session getSession(final MailAccount account) {
        MailClientProperties properties = new MailClientProperties(account);
        return Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(account.getUsername(), account.getPassword());
            }
        });
    }

    @Override
    public void moveMessage(MailAccount account, IMAPMailMessage message, @Nullable String sourceFolder, String targetFolder, boolean removeFlag) throws MessagingException {
        block8: {
            if (sourceFolder == null) {
                sourceFolder = "INBOX";
            }
            if (targetFolder == null) {
                throw new MessagingException("targetFolder must not be null");
            }
            IMAPStore imapStore = null;
            try {
                imapStore = (IMAPStore)this.getSession(account).getStore();
                imapStore.connect();
                IMAPFolder _sourceFolder = (IMAPFolder)imapStore.getFolder(sourceFolder);
                IMAPFolder _targetFolder = (IMAPFolder)imapStore.getFolder(targetFolder);
                MimeMessage referrer = (MimeMessage)message.toIMAPMessage();
                MySearchTerm searchTerm = new MySearchTerm(referrer.getSubject(), referrer.getSize());
                _sourceFolder.open(2);
                Message[] matches = _sourceFolder.search((SearchTerm)searchTerm);
                if (matches != null && matches.length == 1) {
                    _targetFolder.open(2);
                    Message[] _message = new Message[]{matches[0]};
                    if (removeFlag) {
                        _message[0].setFlag(Flags.Flag.FLAGGED, false);
                    }
                    _sourceFolder.setFlags(_message, new Flags(Flags.Flag.SEEN), true);
                    _sourceFolder.copyMessages(_message, (Folder)_targetFolder);
                    _sourceFolder.setFlags(_message, new Flags(Flags.Flag.DELETED), true);
                    _sourceFolder.close(true);
                    _targetFolder.close(false);
                    break block8;
                }
                throw new MessagingException("Could not find message in sourcefolder");
            }
            finally {
                if (imapStore != null && imapStore.isConnected()) {
                    imapStore.close();
                }
            }
        }
    }

    private void handleException(MessagingException e) {
        if (e instanceof AuthenticationFailedException) {
            this.lastError = IMailClient.ErrorTyp.AUTHENTICATION;
        } else if (e.getNextException() instanceof UnknownHostException || e.getNextException() instanceof ConnectException) {
            this.lastError = IMailClient.ErrorTyp.CONNECTION;
        } else if (e instanceof AddressException) {
            this.lastError = IMailClient.ErrorTyp.ADDRESS;
        }
    }

    private class MySearchTerm
    extends SearchTerm {
        private static final long serialVersionUID = -5686587458681566618L;
        private final String subject;
        private final int size;

        public MySearchTerm(String subject, int size) {
            this.subject = subject;
            this.size = size;
        }

        public boolean match(Message msg) {
            try {
                return Objects.equals(msg.getSubject(), this.subject) && msg.getSize() == this.size;
            }
            catch (MessagingException e) {
                logger.warn("Error matching message", (Throwable)e);
                return false;
            }
        }
    }
}

