/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class IntegerStringConverter
implements AttributeConverter<Integer, String> {
    private Logger log = LoggerFactory.getLogger(IntegerStringConverter.class);

    public String convertToDatabaseColumn(Integer objectValue) {
        return Integer.toString(objectValue);
    }

    public Integer convertToEntityAttribute(String dataValue) {
        if (StringUtils.isEmpty((CharSequence)dataValue)) {
            return 0;
        }
        try {
            return Integer.parseInt(dataValue.trim());
        }
        catch (NumberFormatException ex) {
            this.log.warn("Number format exception " + dataValue, (Throwable)ex);
            return 0;
        }
    }
}

