/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.LabItem;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.converter.PathologicDescriptionConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.types.PathologicDescription;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="laborwerte")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="LabResult.patient.item", query="SELECT lr FROM LabResult lr WHERE lr.deleted = false AND lr.patient = :patient AND lr.item = :item"), @NamedQuery(name="LabResult.patient.itemtype.includesDeleted", query="SELECT lr FROM LabResult lr WHERE lr.patient = :patient AND lr.item.typ = :itemtype")})
public class LabResult
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Lob
    protected byte[] extInfo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PatientID")
    private Kontakt patient;
    @Column(name="datum", length=8)
    private LocalDate date;
    @Column(length=6)
    private String zeit;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ItemID")
    private LabItem item;
    @Column(length=255, name="resultat")
    private String result;
    @Convert(converter=IntegerStringConverter.class)
    private int flags;
    @Lob
    @Column(name="Kommentar")
    private String comment;
    @Column(length=255)
    private String unit;
    @Column(length=24)
    private LocalDateTime analysetime;
    @Column(length=24)
    private LocalDateTime observationtime;
    @Column(length=24)
    private LocalDateTime transmissiontime;
    @Column(length=255)
    private String refMale;
    @Column(length=255)
    private String refFemale;
    @OneToOne
    @JoinColumn(name="originId")
    private Kontakt origin;
    @Column(length=128, name="pathoDesc")
    @Convert(converter=PathologicDescriptionConverter.class)
    private PathologicDescription pathologicDescription;
    static final long serialVersionUID = -2854643554651981043L;
    @Transient
    protected WeavedAttributeValueHolderInterface _persistence_item_vh;
    @Transient
    protected WeavedAttributeValueHolderInterface _persistence_patient_vh;

    public LabResult() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.pathologicDescription = new PathologicDescription(PathologicDescription.Description.UNKNOWN);
    }

    @java.beans.Transient
    public boolean isFlagged(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public String getZeit() {
        return this._persistence_get_zeit();
    }

    public void setZeit(String zeit) {
        this._persistence_set_zeit(zeit);
    }

    public LabItem getItem() {
        return this._persistence_get_item();
    }

    public void setItem(LabItem item) {
        this._persistence_set_item(item);
    }

    public String getComment() {
        return this._persistence_get_comment();
    }

    public void setComment(String comment) {
        this._persistence_set_comment(comment);
    }

    public String getUnit() {
        return this._persistence_get_unit();
    }

    public void setUnit(String unit) {
        this._persistence_set_unit(unit);
    }

    public String getRefMale() {
        return this._persistence_get_refMale();
    }

    public void setRefMale(String refMale) {
        this._persistence_set_refMale(refMale);
    }

    public String getRefFemale() {
        return this._persistence_get_refFemale();
    }

    public void setRefFemale(String refFemale) {
        this._persistence_set_refFemale(refFemale);
    }

    public Kontakt getOrigin() {
        return this._persistence_get_origin();
    }

    public void setOrigin(Kontakt origin) {
        this._persistence_set_origin(origin);
    }

    public String getResult() {
        return this._persistence_get_result();
    }

    public void setResult(String result) {
        this._persistence_set_result(result);
    }

    public LocalDate getDate() {
        return this._persistence_get_date();
    }

    public void setDate(LocalDate date) {
        this._persistence_set_date(date);
    }

    public LocalDateTime getAnalysetime() {
        return this._persistence_get_analysetime();
    }

    public void setAnalysetime(LocalDateTime analysetime) {
        this._persistence_set_analysetime(analysetime);
    }

    public LocalDateTime getObservationtime() {
        return this._persistence_get_observationtime();
    }

    public void setObservationtime(LocalDateTime observationtime) {
        this._persistence_set_observationtime(observationtime);
    }

    public LocalDateTime getTransmissiontime() {
        return this._persistence_get_transmissiontime();
    }

    public void setTransmissiontime(LocalDateTime transmissiontime) {
        this._persistence_set_transmissiontime(transmissiontime);
    }

    public int getFlags() {
        return this._persistence_get_flags();
    }

    public void setFlags(int flags) {
        this._persistence_set_flags(flags);
    }

    public PathologicDescription getPathologicDescription() {
        return this._persistence_get_pathologicDescription();
    }

    public void setPathologicDescription(PathologicDescription pathologicDescription) {
        this._persistence_set_pathologicDescription(pathologicDescription);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_item_vh != null) {
            this._persistence_item_vh = (WeavedAttributeValueHolderInterface)this._persistence_item_vh.clone();
        }
        if (this._persistence_patient_vh != null) {
            this._persistence_patient_vh = (WeavedAttributeValueHolderInterface)this._persistence_patient_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new LabResult(persistenceObject);
    }

    public LabResult(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "refMale") {
            return this.refMale;
        }
        if (string == "item") {
            return this.item;
        }
        if (string == "transmissiontime") {
            return this.transmissiontime;
        }
        if (string == "origin") {
            return this.origin;
        }
        if (string == "flags") {
            return this.flags;
        }
        if (string == "zeit") {
            return this.zeit;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        if (string == "result") {
            return this.result;
        }
        if (string == "unit") {
            return this.unit;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "analysetime") {
            return this.analysetime;
        }
        if (string == "observationtime") {
            return this.observationtime;
        }
        if (string == "comment") {
            return this.comment;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "pathologicDescription") {
            return this.pathologicDescription;
        }
        if (string == "refFemale") {
            return this.refFemale;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (LocalDate)object;
            return;
        }
        if (string == "refMale") {
            this.refMale = (String)object;
            return;
        }
        if (string == "item") {
            this.item = (LabItem)object;
            return;
        }
        if (string == "transmissiontime") {
            this.transmissiontime = (LocalDateTime)object;
            return;
        }
        if (string == "origin") {
            this.origin = (Kontakt)object;
            return;
        }
        if (string == "flags") {
            this.flags = (Integer)object;
            return;
        }
        if (string == "zeit") {
            this.zeit = (String)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        if (string == "result") {
            this.result = (String)object;
            return;
        }
        if (string == "unit") {
            this.unit = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "analysetime") {
            this.analysetime = (LocalDateTime)object;
            return;
        }
        if (string == "observationtime") {
            this.observationtime = (LocalDateTime)object;
            return;
        }
        if (string == "comment") {
            this.comment = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "pathologicDescription") {
            this.pathologicDescription = (PathologicDescription)object;
            return;
        }
        if (string == "refFemale") {
            this.refFemale = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(LocalDate localDate) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, localDate);
        this.date = localDate;
    }

    public String _persistence_get_refMale() {
        this._persistence_checkFetched("refMale");
        return this.refMale;
    }

    public void _persistence_set_refMale(String string) {
        this._persistence_checkFetchedForSet("refMale");
        this._persistence_propertyChange("refMale", this.refMale, string);
        this.refMale = string;
    }

    protected void _persistence_initialize_item_vh() {
        if (this._persistence_item_vh == null) {
            this._persistence_item_vh = new ValueHolder((Object)this.item);
            this._persistence_item_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_item_vh() {
        LabItem labItem;
        this._persistence_initialize_item_vh();
        if ((this._persistence_item_vh.isCoordinatedWithProperty() || this._persistence_item_vh.isNewlyWeavedValueHolder()) && (labItem = this._persistence_get_item()) != this._persistence_item_vh.getValue()) {
            this._persistence_set_item(labItem);
        }
        return this._persistence_item_vh;
    }

    public void _persistence_set_item_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_item_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            LabItem labItem = this._persistence_get_item();
            if (labItem != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_item((LabItem)object);
            }
        } else {
            this.item = null;
        }
    }

    public LabItem _persistence_get_item() {
        this._persistence_checkFetched("item");
        this._persistence_initialize_item_vh();
        this.item = (LabItem)this._persistence_item_vh.getValue();
        return this.item;
    }

    public void _persistence_set_item(LabItem labItem) {
        this._persistence_checkFetchedForSet("item");
        this._persistence_initialize_item_vh();
        this.item = (LabItem)this._persistence_item_vh.getValue();
        this._persistence_propertyChange("item", this.item, labItem);
        this.item = labItem;
        this._persistence_item_vh.setValue((Object)labItem);
    }

    public LocalDateTime _persistence_get_transmissiontime() {
        this._persistence_checkFetched("transmissiontime");
        return this.transmissiontime;
    }

    public void _persistence_set_transmissiontime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("transmissiontime");
        this._persistence_propertyChange("transmissiontime", this.transmissiontime, localDateTime);
        this.transmissiontime = localDateTime;
    }

    public Kontakt _persistence_get_origin() {
        this._persistence_checkFetched("origin");
        return this.origin;
    }

    public void _persistence_set_origin(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("origin");
        this._persistence_propertyChange("origin", this.origin, kontakt);
        this.origin = kontakt;
    }

    public int _persistence_get_flags() {
        this._persistence_checkFetched("flags");
        return this.flags;
    }

    public void _persistence_set_flags(int n) {
        this._persistence_checkFetchedForSet("flags");
        this._persistence_propertyChange("flags", new Integer(this.flags), new Integer(n));
        this.flags = n;
    }

    public String _persistence_get_zeit() {
        this._persistence_checkFetched("zeit");
        return this.zeit;
    }

    public void _persistence_set_zeit(String string) {
        this._persistence_checkFetchedForSet("zeit");
        this._persistence_propertyChange("zeit", this.zeit, string);
        this.zeit = string;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }

    public String _persistence_get_result() {
        this._persistence_checkFetched("result");
        return this.result;
    }

    public void _persistence_set_result(String string) {
        this._persistence_checkFetchedForSet("result");
        this._persistence_propertyChange("result", this.result, string);
        this.result = string;
    }

    public String _persistence_get_unit() {
        this._persistence_checkFetched("unit");
        return this.unit;
    }

    public void _persistence_set_unit(String string) {
        this._persistence_checkFetchedForSet("unit");
        this._persistence_propertyChange("unit", this.unit, string);
        this.unit = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    protected void _persistence_initialize_patient_vh() {
        if (this._persistence_patient_vh == null) {
            this._persistence_patient_vh = new ValueHolder((Object)this.patient);
            this._persistence_patient_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_patient_vh() {
        Kontakt kontakt;
        this._persistence_initialize_patient_vh();
        if ((this._persistence_patient_vh.isCoordinatedWithProperty() || this._persistence_patient_vh.isNewlyWeavedValueHolder()) && (kontakt = this._persistence_get_patient()) != this._persistence_patient_vh.getValue()) {
            this._persistence_set_patient(kontakt);
        }
        return this._persistence_patient_vh;
    }

    public void _persistence_set_patient_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_patient_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Kontakt kontakt = this._persistence_get_patient();
            if (kontakt != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_patient((Kontakt)object);
            }
        } else {
            this.patient = null;
        }
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        this._persistence_initialize_patient_vh();
        this.patient = (Kontakt)this._persistence_patient_vh.getValue();
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_initialize_patient_vh();
        this.patient = (Kontakt)this._persistence_patient_vh.getValue();
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
        this._persistence_patient_vh.setValue((Object)kontakt);
    }

    public LocalDateTime _persistence_get_analysetime() {
        this._persistence_checkFetched("analysetime");
        return this.analysetime;
    }

    public void _persistence_set_analysetime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("analysetime");
        this._persistence_propertyChange("analysetime", this.analysetime, localDateTime);
        this.analysetime = localDateTime;
    }

    public LocalDateTime _persistence_get_observationtime() {
        this._persistence_checkFetched("observationtime");
        return this.observationtime;
    }

    public void _persistence_set_observationtime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("observationtime");
        this._persistence_propertyChange("observationtime", this.observationtime, localDateTime);
        this.observationtime = localDateTime;
    }

    public String _persistence_get_comment() {
        this._persistence_checkFetched("comment");
        return this.comment;
    }

    public void _persistence_set_comment(String string) {
        this._persistence_checkFetchedForSet("comment");
        this._persistence_propertyChange("comment", this.comment, string);
        this.comment = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public PathologicDescription _persistence_get_pathologicDescription() {
        this._persistence_checkFetched("pathologicDescription");
        return this.pathologicDescription;
    }

    public void _persistence_set_pathologicDescription(PathologicDescription pathologicDescription) {
        this._persistence_checkFetchedForSet("pathologicDescription");
        this._persistence_propertyChange("pathologicDescription", this.pathologicDescription, pathologicDescription);
        this.pathologicDescription = pathologicDescription;
    }

    public String _persistence_get_refFemale() {
        this._persistence_checkFetched("refFemale");
        return this.refFemale;
    }

    public void _persistence_set_refFemale(String string) {
        this._persistence_checkFetchedForSet("refFemale");
        this._persistence_propertyChange("refFemale", this.refFemale, string);
        this.refFemale = string;
    }
}

