/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.internal;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.jpa.datasource.internal.jfr.JFRQueryExecutionListener;
import ch.elexis.core.utils.CoreUtil;
import java.sql.Driver;
import java.time.Duration;
import java.util.Properties;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class ProxyPoolingDataSourceBuilder {
    public static DataSource build(DBConnection dbConnection) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String driverName = StringUtils.defaultString((String)dbConnection.rdbmsType.driverName);
        String username = StringUtils.defaultString((String)dbConnection.username);
        String password = StringUtils.defaultString((String)dbConnection.password);
        String jdbcString = StringUtils.defaultString((String)dbConnection.connectionString);
        Driver driver = (Driver)Class.forName(driverName).newInstance();
        Properties properties = new Properties();
        properties.put("user", username);
        properties.put("password", password.toString());
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory(driver, jdbcString, properties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(true));
        poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
        poolableConnectionFactory.setValidationQuery("SELECT 1;");
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        connectionPool.setMaxTotal(32);
        connectionPool.setMinIdle(8);
        connectionPool.setMaxWait(Duration.ofSeconds(10L));
        connectionPool.setTestOnBorrow(true);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource poolingDataSource = new PoolingDataSource((ObjectPool)connectionPool);
        JFRQueryExecutionListener jfrQueryExecutionListener = new JFRQueryExecutionListener();
        ProxyDataSourceBuilder proxyDataSourceBuilder = ProxyDataSourceBuilder.create((DataSource)poolingDataSource).listener((QueryExecutionListener)jfrQueryExecutionListener);
        if (CoreUtil.isTestMode()) {
            proxyDataSourceBuilder.countQuery();
        }
        return proxyDataSourceBuilder.build();
    }
}

