/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.IContactResolver;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.LabOrderState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.hl7.model.OrcMessage;
import ch.rgw.tools.TimeTool;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Component
public class LabImportUtil
implements ILabImportUtil {
    private static Logger logger = LoggerFactory.getLogger(LabImportUtil.class);
    @Inject
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    IModelService modelService;
    @Inject
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, target="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore documentStore;
    @Inject
    @Reference
    IEncounterService encounterService;

    @Override
    public ILaboratory getOrCreateLabor(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Labor identifier [" + identifier + "] invalid.");
        }
        ILaboratory ret = null;
        IQuery query = this.modelService.getQuery(ILaboratory.class);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)("%" + identifier + "%"));
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)("%" + identifier + "%"));
        List results = query.execute();
        if (results.isEmpty()) {
            ret = (ILaboratory)this.modelService.create(ILaboratory.class);
            ret.setCode(identifier);
            ret.setDescription1("Labor " + identifier);
            this.modelService.save((Identifiable)ret);
            logger.warn("Found no Labor for identifier [" + identifier + "]. Created new Labor contact.");
        } else {
            ret = (ILaboratory)results.get(0);
            if (results.size() > 1) {
                logger.warn("Found more than one Labor for identifier [" + identifier + "]. This can cause problems when importing results.");
            }
        }
        return ret;
    }

    @Override
    public ILaboratory getLinkLabor(String identifier, IContactResolver<ILaboratory> contactResolver) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Labor identifier [" + identifier + "] invalid.");
        }
        ILaboratory ret = null;
        IQuery query = this.modelService.getQuery(IXid.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IXID__DOMAIN, IQuery.COMPARATOR.EQUALS, (Object)"www.elexis.ch/xid/kontakt/lab/sendingfacility");
        query.and((EStructuralFeature)ModelPackage.Literals.IXID__DOMAIN_ID, IQuery.COMPARATOR.EQUALS, (Object)identifier);
        List xids = query.execute();
        if (!xids.isEmpty()) {
            if (xids.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).error(xids.size() + " Laboratories found with xid [www.elexis.ch/xid/kontakt/lab/sendingfacility] [" + identifier + "] using first");
            }
            return (ILaboratory)((IXid)xids.get(0)).getObject(ILaboratory.class);
        }
        if (contactResolver != null && (ret = contactResolver.getContact(Messages.Core_Select_Laboratory + " [" + identifier + "]")) != null) {
            ret.addXid("www.elexis.ch/xid/kontakt/lab/sendingfacility", identifier, true);
        }
        return ret;
    }

    @Override
    public ILabItem getLabItem(String identifier, ILaboratory labor) {
        ILabMapping mapping = this.getLabMapping(labor, identifier).orElse(null);
        if (mapping != null) {
            return mapping.getItem();
        }
        ILabItem ret = null;
        IQuery query = this.modelService.getQuery(ILabItem.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ITEM__CODE, IQuery.COMPARATOR.EQUALS, (Object)identifier);
        List list = query.execute();
        if (!list.isEmpty()) {
            ret = (ILabItem)list.get(0);
            if (list.size() > 1) {
                logger.warn("Found more than one LabItem for identifier [" + identifier + "] and Labor [" + String.valueOf(labor) + "]. This can cause problems when importing results.");
            }
        }
        return ret;
    }

    public Optional<ILabMapping> getLabMapping(ILaboratory labor, String itemName) {
        List<ILabMapping> mappings = this.getLabMappings(labor, itemName);
        if (!mappings.isEmpty()) {
            if (mappings.size() > 1) {
                throw new IllegalArgumentException(String.format("Found more then 1 mapping for origin id [%s] - [%s]", labor, itemName));
            }
            return Optional.of(mappings.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<ILabResult> getLabResults(IPatient patient, ILabItem item, TimeTool date, TimeTool analyseTime, TimeTool observationTime) {
        if (date == null && analyseTime == null && observationTime == null) {
            throw new IllegalArgumentException("No timestamp specified.");
        }
        IQuery query = this.modelService.getQuery(ILabResult.class, true, false);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__ITEM, IQuery.COMPARATOR.EQUALS, (Object)item);
        if (date != null) {
            query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__DATE, IQuery.COMPARATOR.EQUALS, (Object)date.toLocalDate());
        }
        if (analyseTime != null) {
            query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__ANALYSE_TIME, IQuery.COMPARATOR.EQUALS, (Object)analyseTime.toLocalDateTime());
        }
        if (observationTime != null) {
            query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__OBSERVATION_TIME, IQuery.COMPARATOR.EQUALS, (Object)observationTime.toLocalDateTime());
        }
        return query.execute();
    }

    @Override
    public String importLabResults(List<TransientLabResult> results, ImportHandler importHandler) {
        boolean overWriteAll = false;
        IMandator mandator = this.findMandatorForLabResults(results);
        boolean newResult = false;
        String orderId = null;
        for (TransientLabResult transientLabResult : results) {
            List<ILabResult> existing = this.getExistingResults(transientLabResult);
            if (existing.isEmpty()) {
                ILabOrder createdOrder;
                ILabResult labResult = this.createLabResult(transientLabResult, orderId, mandator);
                newResult = true;
                if (orderId == null && (createdOrder = labResult.getLabOrder()) != null) {
                    orderId = createdOrder.getOrderId();
                }
                LocalLockServiceHolder.get().acquireLock((Object)labResult);
                LocalLockServiceHolder.get().releaseLock((Object)labResult);
                continue;
            }
            for (ILabResult labResult : existing) {
                if (overWriteAll) {
                    LocalLockServiceHolder.get().acquireLock((Object)labResult);
                    transientLabResult.overwriteExisting(labResult);
                    LocalLockServiceHolder.get().releaseLock((Object)labResult);
                    continue;
                }
                if (transientLabResult.isSameResult(labResult)) {
                    logger.info("Result " + labResult.toString() + " already exists.");
                    continue;
                }
                ImportHandler.OverwriteState retVal = importHandler.askOverwrite(transientLabResult.getPatient(), labResult, transientLabResult);
                if (retVal == ImportHandler.OverwriteState.OVERWRITE) {
                    LocalLockServiceHolder.get().acquireLock((Object)labResult);
                    transientLabResult.overwriteExisting(labResult);
                    LocalLockServiceHolder.get().releaseLock((Object)labResult);
                    continue;
                }
                if (retVal == ImportHandler.OverwriteState.OVERWRITEALL) {
                    overWriteAll = true;
                    LocalLockServiceHolder.get().acquireLock((Object)labResult);
                    transientLabResult.overwriteExisting(labResult);
                    LocalLockServiceHolder.get().releaseLock((Object)labResult);
                    continue;
                }
                logger.info("Will not overwrite labResult [" + labResult.getId() + "] due to user decision.");
            }
        }
        if (!newResult && !results.isEmpty()) {
            List<ILabResult> existing = this.getExistingResults(results.get(0));
            for (ILabResult iLabResult : existing) {
                ILabOrder existingOrder = iLabResult.getLabOrder();
                if (existingOrder == null) continue;
                orderId = existingOrder.getOrderId();
            }
        }
        this.modelService.postEvent("info/elexis/model/reload", ILabResult.class);
        return orderId;
    }

    private IMandator findMandatorForLabResults(List<TransientLabResult> results) {
        Optional mandant;
        if (results != null && !results.isEmpty()) {
            IMandator mandant2;
            Optional konsultation;
            Optional patient;
            IPatient iPatient;
            TransientLabResult transientLabResult = results.get(0);
            OrcMessage orcMessage = transientLabResult.getOrcMessage();
            if (orcMessage != null && !orcMessage.getNames().isEmpty()) {
                for (String name : orcMessage.getNames()) {
                    String[] splitNames = name.split(" ");
                    int size = splitNames.length;
                    if (size <= 1) continue;
                    IQuery query = this.modelService.getQuery(IMandator.class);
                    query.startGroup();
                    query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)splitNames[0], true);
                    query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.LIKE, (Object)splitNames[1], true);
                    query.startGroup();
                    query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)splitNames[1], true);
                    query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.LIKE, (Object)splitNames[0], true);
                    query.orJoinGroups();
                    List result = query.execute();
                    if (result.size() != 1) continue;
                    logger.debug("labimport - mandantor [" + String.valueOf(result.get(0)) + "] found with orc name db match");
                    return (IMandator)result.get(0);
                }
                logger.warn("labimport - " + orcMessage.getNames().toString() + " not found or not unique in db - try to find mandantor via last konsultation");
            }
            if ((iPatient = transientLabResult.getPatient()) != null && (patient = CoreModelServiceHolder.get().load(iPatient.getId(), IPatient.class)).isPresent() && (konsultation = this.encounterService.getLatestEncounter((IPatient)patient.get())).isPresent() && (mandant2 = ((IEncounter)konsultation.get()).getMandator()) != null && mandant2.getId() != null) {
                logger.debug("labimport - mandantor found [" + mandant2.getId() + "] with last konsultation");
                return (IMandator)this.modelService.load(mandant2.getId(), IMandator.class).get();
            }
        }
        if ((mandant = ContextServiceHolder.get().getActiveMandator()).isPresent()) {
            logger.debug("labimport - use the active selected mandantor [" + ((IMandator)mandant.get()).getId() + "]");
            return (IMandator)this.modelService.load(((IMandator)mandant.get()).getId(), IMandator.class).get();
        }
        throw new RuntimeException("No mandantor found!");
    }

    private List<ILabResult> getExistingResults(TransientLabResult transientLabResult) {
        List<ILabResult> ret = Collections.emptyList();
        if (!transientLabResult.getLabItem().getTyp().equals((Object)LabItemTyp.DOCUMENT)) {
            ret = transientLabResult.isObservationTime() ? this.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), null, null, transientLabResult.getObservationTime()) : (transientLabResult.isAnalyseTime() ? this.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), null, transientLabResult.getAnalyseTime(), null) : this.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), transientLabResult.getDate(), null, null));
            if (transientLabResult.getSubId() != null) {
                Iterator<ILabResult> it = ret.iterator();
                while (it.hasNext()) {
                    ILabResult result = it.next();
                    String subId = (String)result.getExtInfo((Object)"Hl7SubId");
                    if (subId == null || transientLabResult.getSubId().equals(subId)) continue;
                    it.remove();
                }
            }
        }
        return ret;
    }

    @Override
    public ILabItem createLabItem(String code, String name, ILaboratory origin, String male, String female, String unit, LabItemTyp typ, String group, String priority) {
        ILabItem ret = (ILabItem)this.modelService.create(ILabItem.class);
        ret.setCode(code);
        ret.setName(name);
        ret.setReferenceMale(male);
        ret.setReferenceFemale(female);
        ret.setUnit(unit);
        ret.setTyp(typ);
        ret.setGroup(group);
        ret.setPriority(priority);
        this.modelService.save((Identifiable)ret);
        Optional<ILabMapping> existingMapping = this.getLabMapping(origin, code);
        if (!existingMapping.isPresent()) {
            ILabMapping mapping = (ILabMapping)this.modelService.create(ILabMapping.class);
            mapping.setItem(ret);
            mapping.setOrigin((IContact)origin);
            mapping.setItemName(code);
            this.modelService.save((Identifiable)mapping);
        }
        return ret;
    }

    private List<ILabMapping> getLabMappings(ILaboratory labor, String itemname) {
        INamedQuery query = this.modelService.getNamedQuery(ILabMapping.class, new String[]{"origin", "itemname"});
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("origin", labor);
        parameters.put("itemname", itemname);
        return query.executeWithParameters(parameters);
    }

    private List<ILabItem> getLabItems(String code, String name, LabItemTyp typ) {
        INamedQuery query = this.modelService.getNamedQuery(ILabItem.class, new String[]{"code", "name", "typ"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("code", code);
        parameters.put("name", name);
        parameters.put("typ", (String)typ);
        return query.executeWithParameters(parameters);
    }

    private List<ILabItem> getLabItems(String code, String name) {
        INamedQuery query = this.modelService.getNamedQuery(ILabItem.class, new String[]{"code", "name"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("code", code);
        parameters.put("name", name);
        return query.executeWithParameters(parameters);
    }

    @Override
    public Optional<ILabItem> getDocumentLabItem(String shortname, String name, ILaboratory labor) {
        List<ILabItem> existing;
        List<ILabMapping> mappings = this.getLabMappings(labor, shortname);
        if (!mappings.isEmpty()) {
            for (ILabMapping iLabMapping : mappings) {
                if (iLabMapping.getItem().getTyp() != LabItemTyp.DOCUMENT) continue;
                return Optional.of(iLabMapping.getItem());
            }
        }
        if (!(existing = this.getLabItems(shortname, name, LabItemTyp.DOCUMENT)).isEmpty()) {
            return Optional.of(existing.get(0));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ILabItem> getLabItem(String shortname, String name, ILaboratory labor) {
        List<ILabItem> existing;
        List<ILabMapping> mappings = this.getLabMappings(labor, shortname);
        if (!mappings.isEmpty()) {
            for (ILabMapping iLabMapping : mappings) {
                if (iLabMapping.getItem().getTyp() != LabItemTyp.DOCUMENT) continue;
                return Optional.of(iLabMapping.getItem());
            }
        }
        if (!(existing = this.getLabItems(shortname, name)).isEmpty()) {
            return Optional.of(existing.get(0));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ILabItem> getLabItem(String shortname, String name, LabItemTyp typ) {
        List<ILabItem> existing = this.getLabItems(shortname, name, typ);
        if (!existing.isEmpty()) {
            return Optional.of(existing.get(0));
        }
        return Optional.empty();
    }

    @Override
    public void createDocumentManagerEntry(String title, String lab, byte[] data, String mimeType, TimeTool date, IPatient pat) {
        if (this.documentStore != null) {
            IDocument document = this.documentStore.createDocument(pat.getId(), title, lab);
            document.setCreated(date.getTime());
            document.setMimeType(mimeType);
            try {
                this.documentStore.saveDocument(document, (InputStream)new ByteArrayInputStream(data));
            }
            catch (ElexisException e) {
                logger.error("Error saving document", (Throwable)e);
            }
        } else {
            logger.warn("No IDocumentStore available, document [" + title + "] not created");
        }
    }

    @Override
    public ILabResult createLabResult(IPatient patient, TimeTool date, ILabItem labItem, String result, String comment, String refVal, ILaboratory laboratory, String subId, ILabOrder labOrder, String orderId, IMandator mandator, TimeTool observationTime, String groupName, boolean userResolved) {
        logger.info("Creating result with patient [" + patient.getId() + "] labitem [" + String.valueOf(labItem) + "] origin [" + String.valueOf(laboratory) + "] observationTime [" + String.valueOf(observationTime) + "] labOrder [" + String.valueOf(labOrder) + "]");
        ILabResult labResult = (ILabResult)this.modelService.create(ILabResult.class);
        labResult.setPatient(patient);
        labResult.setDate(date.toLocalDate());
        labResult.setItem(labItem);
        labResult.setOrigin((IContact)laboratory);
        if (patient.getGender() == Gender.FEMALE) {
            labResult.setReferenceFemale(refVal);
        } else {
            labResult.setReferenceMale(refVal);
        }
        labResult.setResult(result);
        labResult.setComment(comment);
        if (labOrder == null) {
            if (observationTime == null) {
                logger.warn("Could not resolve observation time and time for ILabResult [{}], defaulting to now.", (Object)labResult.getId());
                observationTime = new TimeTool();
            }
            ILabOrder order = (ILabOrder)this.modelService.create(ILabOrder.class);
            order.setItem(labItem);
            order.setPatient(patient);
            order.setResult(labResult);
            order.setTimeStamp(LocalDateTime.now());
            order.setObservationTime(observationTime.toLocalDateTime());
            order.setMandator(mandator);
            order.setGroupName(groupName);
            order.setUserResolved(userResolved);
            if (orderId != null) {
                order.setOrderId(orderId);
            }
            ContextServiceHolder.get().getActiveUserContact().ifPresent(uc -> order.setUser(uc));
            labOrder = order;
        } else {
            labOrder.setResult(labResult);
        }
        if (subId != null) {
            labResult.setExtInfo((Object)"Hl7SubId", (Object)subId);
        }
        this.modelService.save((Identifiable)labResult);
        this.modelService.save((Identifiable)labOrder);
        return labResult;
    }

    public ILabResult createLabResult(TransientLabResult transientLabResult, String orderId, IMandator mandantor) {
        ILabResult labResult = null;
        List<ILabOrder> existing = this.getLabOrders(transientLabResult.getPatient(), transientLabResult.getLabItem(), LabOrderState.ORDERED);
        ILabOrder labOrder = null;
        if (existing == null || existing.isEmpty()) {
            TimeTool time = transientLabResult.getObservationTime();
            if (time == null) {
                time = transientLabResult.getDate();
            }
            labResult = transientLabResult.persist(null, orderId, mandantor, time, "Import");
            labOrder = labResult.getLabOrder();
        } else {
            labOrder = existing.get(0);
            labResult = transientLabResult.persist(labOrder, null, null, null, null);
        }
        labOrder.setState(LabOrderState.DONE_IMPORT);
        this.modelService.save((Identifiable)labOrder);
        return labResult;
    }

    private List<ILabOrder> getLabOrders(IPatient patient, ILabItem labItem, LabOrderState state) {
        INamedQuery query = this.modelService.getNamedQuery(ILabOrder.class, new String[]{"item", "patient", "state"});
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("item", labItem);
        parameters.put("patient", patient);
        parameters.put("state", state);
        return query.executeWithParameters(parameters);
    }

    @Override
    public void updateLabResult(ILabResult iLabResult, TransientLabResult transientLabResult) {
        if (iLabResult != null) {
            iLabResult.setExtInfo((Object)"Hl7SubId", (Object)transientLabResult.getSubId());
        }
    }

    @Override
    public <T> Optional<T> loadCoreModel(String id, Class<T> clazz) {
        return this.modelService.load(id, clazz);
    }

    @Override
    public Optional<IPatient> getPatientByCode(String code) {
        if (code != null) {
            INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
            List found = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"code", code}));
            if (!found.isEmpty()) {
                if (found.size() > 1) {
                    logger.warn("Found " + found.size() + " patients with code [" + code + "] using first");
                }
                return Optional.of((IPatient)found.get(0));
            }
        }
        return Optional.empty();
    }
}

