/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.tasks.internal;

import ch.elexis.core.importer.div.importers.IContactResolver;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;

public class HL7ImporterLabContactResolver
implements ILabContactResolver {
    private Logger logger;
    private IModelService coreModelService;
    private ILabImportUtil labImportUtil;
    private boolean bCreateLaboratoryIfNotExists;

    public HL7ImporterLabContactResolver(IModelService coreModelService, ILabImportUtil labImportUtil, Logger logger, boolean bCreateLaboratoryIfNotExists) {
        this.coreModelService = coreModelService;
        this.labImportUtil = labImportUtil;
        this.logger = logger;
        this.bCreateLaboratoryIfNotExists = bCreateLaboratoryIfNotExists;
    }

    @Override
    public ILaboratory getLabContact(String identifier, String sendingFacility) {
        return this.labImportUtil.getLinkLabor(sendingFacility, new MyContactResolver(identifier));
    }

    private class MyContactResolver
    implements IContactResolver<ILaboratory> {
        private final String identifier;

        public MyContactResolver(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public ILaboratory getContact(String message) {
            if (this.identifier == null) {
                HL7ImporterLabContactResolver.this.logger.warn("identifier is null");
                return null;
            }
            ILaboratory laboratory = null;
            IQuery query = HL7ImporterLabContactResolver.this.coreModelService.getQuery(ILaboratory.class);
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)("%" + this.identifier + "%"));
            query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)("%" + this.identifier + "%"));
            List results = query.execute();
            if (results.isEmpty()) {
                if (!HL7ImporterLabContactResolver.this.bCreateLaboratoryIfNotExists) {
                    HL7ImporterLabContactResolver.this.logger.warn("Found no Labor for identifier [{}]. Automatic creation deactivated.", (Object)this.identifier);
                    return null;
                }
                HL7ImporterLabContactResolver.this.logger.info("Found no Labor for identifier [{}]. Created new Labor contact.", (Object)this.identifier);
                laboratory = (ILaboratory)new IContactBuilder.LaboratoryBuilder(HL7ImporterLabContactResolver.this.coreModelService, this.identifier).buildAndSave();
            } else {
                if (results.size() == 1) {
                    return (ILaboratory)results.get(0);
                }
                for (ILaboratory lab : results) {
                    if (!lab.getCode().equalsIgnoreCase(this.identifier.trim())) continue;
                    return lab;
                }
                laboratory = (ILaboratory)results.get(0);
                HL7ImporterLabContactResolver.this.logger.warn("Found more than one Labor for identifier [{}] but no exact match, returning [{}]", (Object)this.identifier, (Object)laboratory.getCode());
            }
            return laboratory;
        }
    }
}

