/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v26;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.message.OML_O21;
import ca.uhn.hl7v2.model.v26.segment.IN1;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.parser.PipeParser;
import ch.elexis.hl7.HL7Writer;
import ch.elexis.hl7.data.HL7Kontakt;
import ch.elexis.hl7.data.HL7Kostentraeger;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.util.HL7Helper;
import java.util.Date;

public class HL7_OML_O21
extends HL7Writer {
    final String uniqueMessageControlID;
    final String uniqueProcessingID;
    final HL7Mandant mandant;

    public HL7_OML_O21(String sendingApplication1, String sendingApplication3, String receivingApplication1, String receivingApplication3, String receivingFacility, String uniqueMessageControlID, String uniqueProcessingID, HL7Mandant mandant) {
        super(sendingApplication1, sendingApplication3, receivingApplication1, receivingApplication3, receivingFacility);
        this.uniqueMessageControlID = uniqueMessageControlID;
        this.uniqueProcessingID = uniqueProcessingID;
        this.mandant = mandant;
    }

    public String createText(HL7Patient patient, HL7Kostentraeger rechnungsempfaenger, HL7Kostentraeger kostentraeger, String plan, Date beginDate, String fallNr, long auftragsNummer) throws DataTypeException, HL7Exception {
        OML_O21 omg = new OML_O21();
        this.fillMSH(omg.getMSH(), "OML", "O21", this.mandant, this.uniqueMessageControlID, this.uniqueProcessingID, patient);
        this.fillPID(omg.getPATIENT().getPID(), patient);
        this.fillNK1(omg.getPATIENT().getNK1(), rechnungsempfaenger);
        this.fillPV1(omg.getPATIENT().getPATIENT_VISIT().getPV1(), patient, beginDate);
        this.fillIN1(omg.getPATIENT().getINSURANCE().getIN1(), patient, kostentraeger, plan, fallNr);
        this.fillORC(omg.getORDER().getORC(), "1", auftragsNummer);
        PipeParser parser = new PipeParser();
        return parser.encode((Message)omg);
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    private void fillNK1(NK1 nk1, HL7Kostentraeger rechnungsempfaenger) throws DataTypeException, HL7Exception {
        nk1.getNk11_SetIDNK1().setValue("1");
        this.addKontaktToXPN(nk1.getNk12_Name(0), (HL7Kontakt)rechnungsempfaenger);
        CWE cwe = nk1.getNk13_Relationship();
        cwe.getCwe1_Identifier().setValue("");
        cwe.getCwe2_Text().setValue("INVOICERECEIPT");
        this.addAddressToXAD(nk1.getNk14_Address(0), (HL7Kontakt)rechnungsempfaenger);
        this.addPhone1ToXTN(nk1.getNk15_PhoneNumber(0), (HL7Kontakt)rechnungsempfaenger);
        this.addPhone2ToXTN(nk1.getNk16_BusinessPhoneNumber(0), rechnungsempfaenger);
    }

    private void fillPV1(PV1 pv1, HL7Patient patient, Date beginDate) throws DataTypeException, HL7Exception {
        pv1.getPv11_SetIDPV1().setValue("1");
        pv1.getPv12_PatientClass().setValue("O");
        pv1.getPv14_AdmissionType().setValue("");
        pv1.getPv15_PreadmitNumber().getCx1_IDNumber().setValue("");
        pv1.getPv16_PriorPatientLocation().getPl1_PointOfCare().setValue("");
        pv1.getPv119_VisitNumber().getIDNumber().setValue("");
        pv1.getPv144_AdmitDateTime().setValue(HL7Helper.dateToString(beginDate));
    }

    private void fillIN1(IN1 in1, HL7Patient patient, HL7Kostentraeger kostentraeger, String plan, String fallNr) throws DataTypeException, HL7Exception {
        in1.getIn11_SetIDIN1().setValue("1");
        in1.getIn12_InsurancePlanID().getCwe1_Identifier().setValue(plan);
        in1.getIn13_InsuranceCompanyID(0).getCx1_IDNumber().setValue("EAN" + kostentraeger.getEan());
        in1.getIn13_InsuranceCompanyID(0).getCx4_AssigningAuthority().getHd1_NamespaceID().setValue("CHEMEDIAT");
        in1.getIn14_InsuranceCompanyName(0).getXon1_OrganizationName().setValue(kostentraeger.getName());
        this.addAddressToXAD(in1.getIn15_InsuranceCompanyAddress(0), (HL7Kontakt)kostentraeger);
        this.addKontaktToXPN(in1.getIn116_NameOfInsured(0), (HL7Kontakt)patient);
        in1.getIn136_PolicyNumber().setValue(fallNr);
        this.addAddressToXAD(in1.getIn119_InsuredSAddress(0), (HL7Kontakt)patient);
    }
}

