/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.types.Gender;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;

public class IPersonHelper
extends IContactHelper {
    private String createLabel(IPerson person) {
        StringBuilder sb = new StringBuilder();
        String titel = person.getTitel();
        String firstName = person.getFirstName();
        String lastName = person.getLastName();
        String titelSuffix = person.getTitelSuffix();
        if (StringUtils.isNotBlank((CharSequence)titel)) {
            sb.append(titel + " ");
        }
        sb.append(firstName);
        sb.append(" " + lastName);
        if (StringUtils.isNotBlank((CharSequence)titelSuffix)) {
            sb.append(", " + titelSuffix);
        }
        return sb.toString();
    }

    public List<HumanName> getHumanNames(IPerson person) {
        ArrayList<HumanName> ret = new ArrayList<HumanName>();
        if (person.isPerson()) {
            HumanName humanName = new HumanName();
            humanName.setFamily(person.getLastName());
            humanName.addGiven(person.getFirstName());
            humanName.addPrefix(person.getTitel());
            humanName.addSuffix(person.getTitelSuffix());
            humanName.setText(this.createLabel(person));
            humanName.setUse(HumanName.NameUse.OFFICIAL);
            ret.add(humanName);
        }
        return ret;
    }

    public Date getBirthDate(IPerson kontakt) {
        LocalDateTime dateOfBirth = kontakt.getDateOfBirth();
        if (dateOfBirth != null) {
            return this.getDate(dateOfBirth);
        }
        return null;
    }

    public Enumerations.AdministrativeGender getGender(Gender gender) {
        if (gender == Gender.FEMALE) {
            return Enumerations.AdministrativeGender.FEMALE;
        }
        if (gender == Gender.MALE) {
            return Enumerations.AdministrativeGender.MALE;
        }
        if (gender == Gender.UNKNOWN) {
            return Enumerations.AdministrativeGender.UNKNOWN;
        }
        return Enumerations.AdministrativeGender.OTHER;
    }

    public void mapHumanName(List<HumanName> names, IPerson target) {
        target.setFirstName(null);
        target.setLastName(null);
        target.setTitel(null);
        target.setTitelSuffix(null);
        for (HumanName humanName : names) {
            if (names.size() != 1 && !HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            target.setFirstName(humanName.getGivenAsSingleString());
            target.setLastName(humanName.getFamily());
            target.setTitel(humanName.getPrefixAsSingleString());
            target.setTitelSuffix(humanName.getSuffixAsSingleString());
        }
    }

    public void mapGender(Enumerations.AdministrativeGender gender, IPerson target) {
        if (gender != null) {
            switch (gender) {
                case FEMALE: {
                    target.setGender(Gender.FEMALE);
                    break;
                }
                case MALE: {
                    target.setGender(Gender.MALE);
                    break;
                }
                case UNKNOWN: {
                    target.setGender(Gender.UNKNOWN);
                    break;
                }
                default: {
                    target.setGender(Gender.UNDEFINED);
                }
            }
        }
    }

    public void mapBirthDate(Date birthDate, IPerson target) {
        if (birthDate != null) {
            LocalDateTime dob = birthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            target.setDateOfBirth(dob);
        } else {
            target.setDateOfBirth(null);
        }
    }
}

