/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.time.TimeUtil;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.StringType;
import org.slf4j.LoggerFactory;

public class IAppointmentHelper
extends AbstractHelper {
    public String getDescription(IAppointment localObject) {
        return localObject.getReason();
    }

    public void mapApplyAppointmentStateAndType(Appointment target, IAppointment source, IConfigService configService) {
        Extension extension = new Extension();
        extension.setUrl("http://elexis.info/codeelement/config/appointment/");
        String state = source.getState();
        Extension statusExtension = new Extension("state", (IBaseDatatype)new StringType(state));
        extension.addExtension(statusExtension);
        String type = source.getType();
        Extension typeExtension = new Extension("type", (IBaseDatatype)new StringType(type));
        extension.addExtension(typeExtension);
        target.getExtension().add(extension);
    }

    public void mapApplyAppointmentStateAndType(IAppointment target, Appointment source) {
        Extension extensionByUrl = source.getExtensionByUrl("http://elexis.info/codeelement/config/appointment/");
        if (extensionByUrl != null) {
            Extension typeExtension;
            Extension statusExtension = extensionByUrl.getExtensionByUrl("state");
            if (statusExtension != null) {
                String status = statusExtension.getValue().toString();
                target.setState(status);
            }
            if ((typeExtension = extensionByUrl.getExtensionByUrl("type")) != null) {
                String type = typeExtension.getValue().toString();
                target.setType(type);
            }
        }
    }

    public void mapApplyStartEndMinutes(Slot target, IAppointment source) {
        LocalDateTime end;
        LocalDateTime start = source.getStartTime();
        if (start != null) {
            Date start_ = TimeUtil.toDate((LocalDateTime)start);
            target.setStart(start_);
            if (source.isAllDay()) {
                LocalDateTime endOfDay = start.toLocalDate().atTime(LocalTime.MAX);
                Date _endOfDay = TimeUtil.toDate((LocalDateTime)endOfDay);
                target.setEnd(_endOfDay);
                return;
            }
        }
        if ((end = source.getEndTime()) != null) {
            Date end_ = TimeUtil.toDate((LocalDateTime)end);
            target.setEnd(end_);
        }
    }

    public void mapApplyStartEndMinutes(Appointment target, IAppointment source) {
        Integer durationMinutes;
        LocalDateTime end;
        LocalDateTime start = source.getStartTime();
        if (start != null) {
            Date start_ = TimeUtil.toDate((LocalDateTime)start);
            target.setStart(start_);
            if (source.isAllDay()) {
                LocalDateTime endOfDay = start.toLocalDate().atTime(LocalTime.MAX);
                Date _endOfDay = TimeUtil.toDate((LocalDateTime)endOfDay);
                target.setEnd(_endOfDay);
                return;
            }
        }
        if ((end = source.getEndTime()) != null) {
            Date end_ = TimeUtil.toDate((LocalDateTime)end);
            target.setEnd(end_);
        }
        if ((durationMinutes = source.getDurationMinutes()) != null) {
            target.setMinutesDuration(durationMinutes.intValue());
        }
    }

    public void mapApplyStartEndMinutes(IAppointment target, Appointment source) {
        this.mapApplyStartEndMinutes(target, source.getStart(), source.getEnd());
    }

    public void mapApplyStartEndMinutes(IAppointment target, Slot source) {
        this.mapApplyStartEndMinutes(target, source.getStart(), source.getEnd());
    }

    public void mapApplyStartEndMinutes(IAppointment target, Date start, Date end) {
        if (start == null) {
            start = new Date();
            LoggerFactory.getLogger(this.getClass()).warn("Appointment F->E [{}] no start time, setting now");
        }
        LocalDateTime _start = TimeUtil.toLocalDateTime((Date)start);
        target.setStartTime(_start);
        if (end == null) {
            end = new Date(start.getTime() + 300000L);
            LoggerFactory.getLogger(this.getClass()).warn("Appointment F->E [{}] no end time, setting to start+5m");
        }
        LocalDateTime _end = TimeUtil.toLocalDateTime((Date)end);
        target.setEndTime(_end);
        if (_start.toLocalDate().atStartOfDay().withNano(0).equals(_start.withNano(0)) && _end.toLocalDate().atTime(LocalTime.MAX).withNano(0).equals(_end.withNano(0))) {
            target.setEndTime(null);
        }
    }
}

