/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.model.ICodeElement;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;
import org.osgi.service.component.annotations.Component;

@Component
public class ValueSetListTransformer
implements IFhirTransformer<ValueSet, List<ICodeElement>> {
    @Override
    public Optional<ValueSet> getFhirObject(List<ICodeElement> localObjects, SummaryEnum summaryEnum, Set<Include> includes) {
        ValueSet valueSet = new ValueSet();
        valueSet.setId((IIdType)new IdDt("ValueSet", "virtual"));
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        ValueSet.ValueSetComposeComponent vscc = new ValueSet.ValueSetComposeComponent();
        valueSet.setCompose(vscc);
        ValueSet.ConceptSetComponent conceptSetComponent = vscc.addInclude();
        localObjects.stream().map(c -> this.toConceptReferenceComponent((ICodeElement)c)).forEach(crc -> {
            ValueSet.ConceptSetComponent conceptSetComponent2 = conceptSetComponent.addConcept(crc);
        });
        return Optional.of(valueSet);
    }

    @Override
    public Optional<List<ICodeElement>> getLocalObject(ValueSet fhirObject) {
        return null;
    }

    @Override
    public Optional<List<ICodeElement>> updateLocalObject(ValueSet fhirObject, List<ICodeElement> localObject) {
        return null;
    }

    @Override
    public Optional<List<ICodeElement>> createLocalObject(ValueSet fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return ValueSet.class.equals(fhirClazz) && List.class.equals(localClazz);
    }

    public ValueSet.ConceptReferenceComponent toConceptReferenceComponent(ICodeElement codeElement) {
        CodeType codeType = new CodeType(codeElement.getCode());
        ValueSet.ConceptReferenceComponent crc = new ValueSet.ConceptReferenceComponent(codeType);
        crc.setDisplay(codeElement.getText());
        return crc;
    }
}

