/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.ICoverageHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.ICoverageCoverageAttributeMapper;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Coverage;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CoverageICoverageTransformer
implements IFhirTransformer<Coverage, ICoverage> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private ICoverageCoverageAttributeMapper attributeMapper;

    @Activate
    public void activate() {
        this.attributeMapper = new ICoverageCoverageAttributeMapper(this.coreModelService);
    }

    @Override
    public Optional<Coverage> getFhirObject(ICoverage localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Coverage coverage = new Coverage();
        this.attributeMapper.elexisToFhir(localObject, coverage, summaryEnum, includes);
        return Optional.of(coverage);
    }

    @Override
    public Optional<ICoverage> getLocalObject(Coverage fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.coreModelService.load(localId.get(), ICoverage.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ICoverage> updateLocalObject(Coverage fhirObject, ICoverage localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<ICoverage> createLocalObject(Coverage fhirObject) {
        if (!fhirObject.hasBeneficiary()) {
            throw new PreconditionFailedException("Beneficiary missing");
        }
        Optional patient = this.coreModelService.load(fhirObject.getBeneficiary().getReferenceElement().getIdPart(), IPatient.class);
        if (patient.isEmpty()) {
            throw new PreconditionFailedException("Invalid patient");
        }
        Optional<String> type = new ICoverageHelper().getType(fhirObject);
        if (type.isEmpty()) {
            throw new PreconditionFailedException("BillingSystem missing");
        }
        ICoverage create = new ICoverageBuilder(this.coreModelService, (IPatient)patient.get(), "online created", FallConstants.TYPE_DISEASE, type.get()).buildAndSave();
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.coreModelService.save((Identifiable)create);
        return Optional.of(create);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Coverage.class.equals(fhirClazz) && ICoverage.class.equals(localClazz);
    }
}

