/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.AbstractFindingsAccessor;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Reference;

public class EncounterAccessor
extends AbstractFindingsAccessor {
    public Optional<LocalDateTime> getStartTime(DomainResource resource) {
        Encounter fhirEncounter = (Encounter)resource;
        Period period = fhirEncounter.getPeriod();
        if (period != null && period.getStart() != null) {
            return Optional.of(this.getLocalDateTime(period.getStart()));
        }
        return Optional.empty();
    }

    public void setStartTime(DomainResource resource, LocalDateTime time) {
        Encounter fhirEncounter = (Encounter)resource;
        Period period = fhirEncounter.getPeriod();
        if (period == null) {
            period = new Period();
        }
        period.setStart(this.getDate(time));
        fhirEncounter.setPeriod(period);
    }

    public Optional<LocalDateTime> getEndTime(DomainResource resource) {
        Encounter fhirEncounter = (Encounter)resource;
        Period period = fhirEncounter.getPeriod();
        if (period != null && period.getEnd() != null) {
            return Optional.of(this.getLocalDateTime(period.getEnd()));
        }
        return Optional.empty();
    }

    public void setEndTime(DomainResource resource, LocalDateTime time) {
        Encounter fhirEncounter = (Encounter)resource;
        Period period = fhirEncounter.getPeriod();
        if (period == null) {
            period = new Period();
        }
        period.setEnd(this.getDate(time));
        fhirEncounter.setPeriod(period);
    }

    public List<ICondition> getIndication(DomainResource resource) {
        ArrayList<ICondition> indication = new ArrayList<ICondition>();
        Encounter fhirEncounter = (Encounter)resource;
        List theIndication = fhirEncounter.getDiagnosis();
        for (Encounter.DiagnosisComponent component : theIndication) {
            Reference reference = component.getCondition();
            if (reference.getReference() == null) continue;
            String idString = reference.getReferenceElement().getIdPart();
            ModelUtil.loadFinding(idString, ICondition.class).ifPresent(condition -> {
                boolean bl = indication.add((ICondition)condition);
            });
        }
        return indication;
    }

    public void setIndication(DomainResource resource, List<ICondition> indication) {
        Encounter fhirEncounter = (Encounter)resource;
        ArrayList<Encounter.DiagnosisComponent> theIndication = new ArrayList<Encounter.DiagnosisComponent>();
        for (ICondition iCondition : indication) {
            theIndication.add(new Encounter.DiagnosisComponent(new Reference((IIdType)new IdDt("Condition", iCondition.getId()))));
        }
        fhirEncounter.setDiagnosis(theIndication);
    }

    public List<ICoding> getType(DomainResource resource) {
        Encounter fhirEncounter = (Encounter)resource;
        List codeableConcepts = fhirEncounter.getType();
        if (codeableConcepts != null) {
            ArrayList<ICoding> ret = new ArrayList<ICoding>();
            for (CodeableConcept codeableConcept : codeableConcepts) {
                ret.addAll(ModelUtil.getCodingsFromConcept(codeableConcept));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public void setType(DomainResource resource, List<ICoding> coding) {
        Encounter fhirEncounter = (Encounter)resource;
        List codeableConcepts = fhirEncounter.getType();
        if (!codeableConcepts.isEmpty()) {
            codeableConcepts.clear();
        }
        CodeableConcept codeableConcept = new CodeableConcept();
        ModelUtil.setCodingsToConcept(codeableConcept, coding);
        fhirEncounter.setType(Collections.singletonList(codeableConcept));
    }

    public void setPatientId(DomainResource resource, String patientId) {
        Encounter fhirEncounter = (Encounter)resource;
        fhirEncounter.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
    }

    public void setConsultationId(DomainResource resource, String consultationId) {
        Encounter fhirEncounter = (Encounter)resource;
        boolean identifierFound = false;
        List existing = fhirEncounter.getIdentifier();
        for (Identifier existingIdentifier : existing) {
            if (!IdentifierSystem.ELEXIS_CONSID.getSystem().equals(existingIdentifier.getSystem())) continue;
            existingIdentifier.setValue(consultationId);
            identifierFound = true;
            break;
        }
        if (!identifierFound) {
            Identifier identifier = fhirEncounter.addIdentifier();
            identifier.setSystem(IdentifierSystem.ELEXIS_CONSID.getSystem());
            identifier.setValue(consultationId);
        }
    }

    public void setMandatorId(DomainResource resource, String mandatorId) {
        Encounter fhirEncounter = (Encounter)resource;
        Encounter.EncounterParticipantComponent participant = new Encounter.EncounterParticipantComponent();
        participant.setIndividual(new Reference("Practitioner/" + mandatorId));
        fhirEncounter.addParticipant(participant);
    }

    public void setPrimaryPerformer(Encounter target, IMandator mandator) {
        Encounter.EncounterParticipantComponent participant = new Encounter.EncounterParticipantComponent();
        participant.getTypeFirstRep().addCoding(new Coding("http://hl7.org/fhir/ValueSet/encounter-participant-type", "PPRF", "primary performer"));
        participant.setIndividual(new Reference("Practitioner/" + mandator.getId()));
        target.addParticipant(participant);
    }

    public void setAttender(Encounter target, IContact mandator) {
        Encounter.EncounterParticipantComponent participant = new Encounter.EncounterParticipantComponent();
        participant.getTypeFirstRep().addCoding(new Coding("http://hl7.org/fhir/ValueSet/encounter-participant-type", "ATND", "attender"));
        participant.setIndividual(new Reference("Practitioner/" + mandator.getId()));
        target.addParticipant(participant);
    }
}

