/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.services.IModelService;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Observation;

public class CodeTypeUtil {
    public static Optional<String> getSystem(CodeType code) {
        String[] parts;
        String codeValue = (String)code.getValue();
        if (codeValue != null && (parts = codeValue.split("\\|")).length == 2) {
            return Optional.of(parts[0]);
        }
        return Optional.empty();
    }

    public static Optional<String> getCode(CodeType code) {
        String codeValue = (String)code.getValue();
        if (codeValue != null) {
            String[] parts = codeValue.split("\\|");
            if (parts.length == 2) {
                return Optional.of(parts[1]);
            }
            if (parts.length == 1) {
                return Optional.of(parts[0]);
            }
        }
        return Optional.empty();
    }

    public static boolean isVitoLabkey(IModelService modelService, Observation observation, String codeString) {
        String[] parts;
        String export;
        ILabItem item;
        String labresultId = observation.getIdElement().getIdPart();
        Optional result = modelService.load(labresultId, ILabResult.class);
        if (result.isPresent() && (item = ((ILabResult)result.get()).getItem()) != null && (export = item.getExport()) != null && export.startsWith("vitolabkey:") && (parts = export.split(":")).length == 2 && (parts = parts[1].split(",")).length > 0) {
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(codeString)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isCodeInConcept(CodeableConcept concept, String system, String code) {
        List codings = concept.getCoding();
        for (Coding coding : codings) {
            if (coding.getSystem() == null || coding.getCode() == null || !coding.getSystem().equals(system) || !coding.getCode().equals(code)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCodeInConceptList(List<CodeableConcept> conceptList, String system, String code) {
        for (CodeableConcept codeableConcept : conceptList) {
            if (!CodeTypeUtil.isCodeInConcept(codeableConcept, system, code)) continue;
            return true;
        }
        return false;
    }
}

