/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.transformer.helper.IPersonHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IXidService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Practitioner;

public class IPersonPractitionerAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IPerson, Practitioner> {
    private IXidService xidService;
    private IPersonHelper personHelper;

    public IPersonPractitionerAttributeMapper(IXidService xidService) {
        this.xidService = xidService;
        this.personHelper = new IPersonHelper();
    }

    @Override
    public void elexisToFhir(IPerson source, Practitioner target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt("Practitioner", source.getId(), Long.toString(source.getLastupdate())));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        List<Identifier> identifiers = this.personHelper.getIdentifiers((IContact)source, this.xidService);
        target.setIdentifier(identifiers);
        target.setActive(!source.isDeleted());
        target.setName(this.personHelper.getHumanNames(source));
        target.setGender(this.personHelper.getGender(source.getGender()));
        target.setBirthDate(this.personHelper.getBirthDate(source));
        target.setAddress(this.personHelper.getAddresses((IContact)source));
        target.setTelecom(this.personHelper.getContactPoints((IContact)source));
        Attachment mapContactImage = this.personHelper.mapContactImage((IContact)source);
        target.setPhoto(mapContactImage != null ? Collections.singletonList(mapContactImage) : null);
    }

    @Override
    public void fhirToElexis(Practitioner source, IPerson target) {
        target.setMandator(true);
        this.personHelper.mapIdentifiers(source.getIdentifier(), (IContact)target);
        this.personHelper.mapHumanName(source.getName(), target);
        this.personHelper.mapAddress(source.getAddress(), (IContact)target);
        this.personHelper.mapGender(source.getGender(), target);
        this.personHelper.mapBirthDate(source.getBirthDate(), target);
        this.personHelper.mapTelecom(source.getTelecom(), (IContact)target);
    }
}

