/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.time.TimeUtil;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class IInvoiceInvoiceAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IInvoice, Invoice> {
    private IFhirTransformer<ChargeItem, IBilled> chargeItemBilledTransformer;

    public IInvoiceInvoiceAttributeMapper(IFhirTransformer<ChargeItem, IBilled> chargeItemBilledTransformer) {
        this.chargeItemBilledTransformer = chargeItemBilledTransformer;
    }

    private IInvoiceInvoiceAttributeMapper() {
    }

    @Override
    public void elexisToFhir(IInvoice source, Invoice target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Invoice.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        target.setStatus(this.toInvoiceStatus(source.getState()));
        ICoverage coverage = source.getCoverage();
        IPatient patient = coverage != null ? coverage.getPatient() : null;
        target.setSubject(FhirUtil.getReference((Identifiable)patient));
        target.setDate(TimeUtil.toDate((LocalDate)source.getDate()));
        Money sumTotal = new Money(0);
        List billed = source.getBilled();
        for (IBilled iBilled : billed) {
            target.addLineItem(this.toInvoiceLineItemComponent(iBilled, includes, sumTotal));
        }
        target.setTotalGross(FhirUtil.toFhir(sumTotal));
    }

    private Invoice.InvoiceStatus toInvoiceStatus(InvoiceState state) {
        switch (state) {
            case CANCELLED: {
                return Invoice.InvoiceStatus.CANCELLED;
            }
            case BILLED: 
            case OPEN: 
            case OPEN_AND_PRINTED: {
                return Invoice.InvoiceStatus.ISSUED;
            }
            case PAID: {
                return Invoice.InvoiceStatus.BALANCED;
            }
        }
        return Invoice.InvoiceStatus.DRAFT;
    }

    public Invoice.InvoiceLineItemComponent toInvoiceLineItemComponent(IBilled iBilled, Set<Include> includes, Money sum) {
        Invoice.InvoiceLineItemComponent ilic = new Invoice.InvoiceLineItemComponent((Type)FhirUtil.getReference((Identifiable)iBilled));
        if (includes.contains(new Include("Invoice.lineItem.chargeItem"))) {
            ChargeItem chargeItem = this.chargeItemBilledTransformer.getFhirObject(iBilled).get();
            ((Reference)ilic.getChargeItem()).setResource((IBaseResource)chargeItem);
        }
        Invoice.InvoiceLineItemPriceComponentComponent ilipcc = new Invoice.InvoiceLineItemPriceComponentComponent();
        ilic.setPriceComponent(Collections.singletonList(ilipcc));
        ilipcc.setType(Invoice.InvoicePriceComponentType.BASE);
        ilipcc.setFactor(iBilled.getFactor());
        Money total = iBilled.getTotal();
        ilipcc.setAmount(FhirUtil.toFhir(total));
        sum.addMoney(total);
        return ilic;
    }

    @Override
    public void fhirToElexis(Invoice source, IInvoice target) {
        throw new UnsupportedOperationException();
    }
}

