/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.EncounterAccessor;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;

public class IEncounterEncounterAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IEncounter, Encounter> {
    private EncounterAccessor accessor = new EncounterAccessor();

    @Override
    public void elexisToFhir(IEncounter source, Encounter target, SummaryEnum summaryEnum, Set<Include> includes) {
        VersionedResource vr;
        IPatient patient;
        ICoverage coverage;
        LocalDateTime encounterDateTime = source.getTimeStamp();
        LocalDate encounterDate = source.getDate();
        if (encounterDate != null) {
            this.accessor.setStartTime((DomainResource)target, encounterDateTime != null ? encounterDateTime : encounterDate.atStartOfDay());
            this.accessor.setEndTime((DomainResource)target, encounterDate.atTime(23, 59, 59));
        }
        if ((coverage = source.getCoverage()) != null && (patient = coverage.getPatient()) != null) {
            this.accessor.setPatientId((DomainResource)target, patient.getId());
        }
        if (source.getMandator() != null) {
            this.accessor.setPrimaryPerformer(target, source.getMandator());
            if (source.getMandator().getBiller().isPerson() && source.getMandator().getBiller().isMandator() && !source.getMandator().equals(source.getMandator().getBiller())) {
                this.accessor.setAttender(target, source.getMandator().getBiller());
            }
        }
        if ((vr = source.getVersionedEntry()) != null) {
            Samdas samdas = new Samdas(vr.getHead());
            this.accessor.setText((DomainResource)target, samdas.getRecordText());
        }
        List<ICoding> coding = this.accessor.getType((DomainResource)target);
        if (!ModelUtil.isSystemInList(CodingSystem.ELEXIS_ENCOUNTER_TYPE.getSystem(), coding)) {
            coding.add(new TransientCoding(CodingSystem.ELEXIS_ENCOUNTER_TYPE.getSystem(), "text", "Nicht strukturierte Konsultation"));
            this.accessor.setType((DomainResource)target, coding);
        }
    }

    @Override
    public void fhirToElexis(Encounter source, IEncounter target) {
        if (source.hasPeriod() && source.getPeriod().hasStart()) {
            target.setTimeStamp(LocalDateTime.ofInstant(source.getPeriod().getStart().toInstant(), ZoneId.systemDefault()));
        }
        if (source.hasText()) {
            this.updateConsText(source, target);
        }
    }

    private void updateConsText(Encounter fhirObject, IEncounter cons) {
        Optional<String> consText = ModelUtil.getNarrativeAsString(fhirObject.getText());
        if (consText.isPresent()) {
            String existingText = cons.getHeadVersionInPlaintext();
            if (!consText.get().equals(existingText)) {
                Samdas samdas = new Samdas(cons.getVersionedEntry().getHead());
                Samdas.Record rec = samdas.getRecord();
                rec.setText(consText.get());
                EncounterServiceHolder.get().updateVersionedEntry(cons, samdas);
            }
        }
    }
}

