/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IPersonPractitionerAttributeMapper;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Practitioner;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"transformer.id=Practitioner.IPerson"})
public class PractitionerIPersonTransformer
implements IFhirTransformer<Practitioner, IPerson> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    private IPersonPractitionerAttributeMapper attributeMapper;

    @Activate
    private void activate() {
        this.attributeMapper = new IPersonPractitionerAttributeMapper(this.xidService);
    }

    @Override
    public Optional<Practitioner> getFhirObject(IPerson localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Practitioner practitioner = new Practitioner();
        this.attributeMapper.elexisToFhir(localObject, practitioner, summaryEnum, includes);
        return Optional.of(practitioner);
    }

    @Override
    public Optional<IPerson> getLocalObject(Practitioner fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.modelService.load(id, IPerson.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IPerson> updateLocalObject(Practitioner fhirObject, IPerson localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IPerson> createLocalObject(Practitioner fhirObject) {
        IPerson mandator = (IPerson)this.modelService.create(IPerson.class);
        mandator.setMandator(true);
        this.attributeMapper.fhirToElexis(fhirObject, mandator);
        this.modelService.save((Identifiable)mandator);
        return Optional.of(mandator);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Practitioner.class.equals(fhirClazz) && IPerson.class.equals(localClazz);
    }
}

