/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.FhirTransformerCache;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IPatientPatientAttributeMapper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hl7.fhir.r4.model.Patient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"transformer.id=Patient.IPatient"})
public class PatientIPatientTransformer
implements IFhirTransformer<Patient, IPatient> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    private IPatientPatientAttributeMapper attributeMapper;
    private FhirTransformerCache<Patient> cache;

    @Activate
    private void activate() {
        this.attributeMapper = new IPatientPatientAttributeMapper(this.modelService, this.xidService);
        this.cache = new FhirTransformerCache();
    }

    @Override
    public Optional<Patient> getFhirObject(final IPatient localObject, final SummaryEnum summaryEnum, final Set<Include> includes) {
        return this.cache.get((Identifiable)localObject, summaryEnum, includes, new Callable<Patient>(){

            @Override
            public Patient call() throws Exception {
                Patient ret = new Patient();
                PatientIPatientTransformer.this.attributeMapper.elexisToFhir(localObject, ret, summaryEnum, (Set<Include>)includes);
                return ret;
            }
        });
    }

    @Override
    public Optional<IPatient> getLocalObject(Patient fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.modelService.load(localId.get(), IPatient.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends Identifiable> getLocalObjectForReference(String fhirReference) {
        Optional<String> localId;
        if (fhirReference.startsWith(Patient.class.getSimpleName()) && (localId = FhirUtil.getLocalId(fhirReference)).isPresent()) {
            return this.modelService.load(localId.get(), IPatient.class);
        }
        return IFhirTransformer.super.getLocalObjectForReference(fhirReference);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Patient.class.equals(fhirClazz) && IPatient.class.equals(localClazz);
    }

    @Override
    public Optional<IPatient> updateLocalObject(Patient fhirObject, IPatient localObject) {
        this.cache.invalidate((Identifiable)localObject);
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IPatient> createLocalObject(Patient fhirObject) {
        IPatient create = (IPatient)this.modelService.create(IPatient.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.modelService.save((Identifiable)create);
        return Optional.of(create);
    }
}

