/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IVaccinationImmunizationAttributeMapper;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IVaccination;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IVaccinationBuilder;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.utils.CoreUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Immunization;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class ImmunizationVaccinationTransformer
implements IFhirTransformer<Immunization, IVaccination> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IContextService contextService;
    @Reference
    private ICodeElementService codeElemetService;
    private IVaccinationImmunizationAttributeMapper attributeMapper;

    @Activate
    public void activate() {
        this.attributeMapper = new IVaccinationImmunizationAttributeMapper(this.modelService);
    }

    @Override
    public Optional<Immunization> getFhirObject(IVaccination localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Immunization fhirObject = new Immunization();
        this.attributeMapper.elexisToFhir(localObject, fhirObject, summaryEnum, includes);
        return Optional.of(fhirObject);
    }

    @Override
    public Optional<IVaccination> getLocalObject(Immunization fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.modelService.load(id, IVaccination.class);
        }
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Immunization.class.equals(fhirClazz) && IVaccination.class.equals(localClazz);
    }

    @Override
    public Optional<IVaccination> updateLocalObject(Immunization fhirObject, IVaccination localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IVaccination> createLocalObject(Immunization fhirObject) {
        Optional patient;
        Optional item = Optional.empty();
        Optional<String> gtin = this.getImmunizationGtin(fhirObject);
        Optional<String> atc = this.getImmunizationAtc(fhirObject);
        Optional<String> displayName = this.getImmunizationDisplay(fhirObject);
        if (gtin.isPresent()) {
            item = this.codeElemetService.findArticleByGtin(gtin.get());
            if (item.isEmpty() && CoreUtil.isTestMode()) {
                IQuery query = this.modelService.getQuery(IArticle.class);
                query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__GTIN, IQuery.COMPARATOR.EQUALS, (Object)gtin.get());
                item = query.executeSingleResult();
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Immunization with no gtin");
        }
        if ((patient = this.modelService.load((String)FhirUtil.getId(fhirObject.getPatient()).orElse(null), IPatient.class)).isPresent()) {
            IVaccination localObject = null;
            localObject = item.isPresent() ? (IVaccination)new IVaccinationBuilder(this.modelService, this.contextService, (IArticle)item.get(), (IPatient)patient.get()).build() : (IVaccination)new IVaccinationBuilder(this.modelService, this.contextService, displayName.orElse("unknown vaccine"), (String)gtin.orElse(null), (String)atc.orElse(null), (IPatient)patient.get()).build();
            this.attributeMapper.fhirToElexis(fhirObject, localObject);
            this.modelService.save((Identifiable)localObject);
            return Optional.of(localObject);
        }
        LoggerFactory.getLogger(this.getClass()).error("Immunization with unknown patient [" + (String)FhirUtil.getId(fhirObject.getPatient()).orElse(null) + "]");
        return Optional.empty();
    }

    private Optional<String> getImmunizationDisplay(Immunization fhirObject) {
        CodeableConcept vaccination = fhirObject.getVaccineCode();
        if (vaccination instanceof CodeableConcept) {
            List codings = vaccination.getCoding();
            for (Coding coding : codings) {
                String codeSystem = coding.getSystem();
                if (!MedicamentCoding.GTIN.getUrl().equals(codeSystem) && !MedicamentCoding.GTIN.getOid().equals(codeSystem)) continue;
                return Optional.of(coding.getDisplay());
            }
        }
        return Optional.empty();
    }

    private Optional<String> getImmunizationAtc(Immunization fhirObject) {
        CodeableConcept vaccination = fhirObject.getVaccineCode();
        if (vaccination instanceof CodeableConcept) {
            List codings = vaccination.getCoding();
            for (Coding coding : codings) {
                String codeSystem = coding.getSystem();
                if (!MedicamentCoding.ATC.getUrl().equals(codeSystem) && !MedicamentCoding.ATC.getOid().equals(codeSystem)) continue;
                return Optional.of(coding.getCode());
            }
        }
        return Optional.empty();
    }

    private Optional<String> getImmunizationGtin(Immunization fhirObject) {
        CodeableConcept vaccination = fhirObject.getVaccineCode();
        if (vaccination instanceof CodeableConcept) {
            List codings = vaccination.getCoding();
            for (Coding coding : codings) {
                String codeSystem = coding.getSystem();
                if (!MedicamentCoding.GTIN.getUrl().equals(codeSystem) && !MedicamentCoding.GTIN.getOid().equals(codeSystem)) continue;
                return Optional.of(coding.getCode());
            }
        }
        return Optional.empty();
    }
}

