/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.accessor.AllergyIntoleranceAccessor;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AllergyIntoleranceIAllergyIntoleranceTransformer
implements IFhirTransformer<AllergyIntolerance, IAllergyIntolerance> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IFindingsService findingsService;
    private AllergyIntoleranceAccessor accessor = new AllergyIntoleranceAccessor();
    private FindingsContentHelper contentHelper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
    }

    @Override
    public Optional<AllergyIntolerance> getFhirObject(IAllergyIntolerance localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            AllergyIntolerance fhirObject = (AllergyIntolerance)resource.get();
            FhirUtil.setVersionedIdPartLastUpdatedMeta(AllergyIntolerance.class, (DomainResource)fhirObject, (Identifiable)localObject);
            return Optional.of(fhirObject);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IAllergyIntolerance> getLocalObject(AllergyIntolerance fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(FhirUtil.getLocalId(fhirObject.getId()).orElse(""), IAllergyIntolerance.class)).isPresent()) {
            return Optional.of((IAllergyIntolerance)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IAllergyIntolerance> updateLocalObject(AllergyIntolerance fhirObject, IAllergyIntolerance localObject) {
        Optional<String> fhirText = ModelUtil.getNarrativeAsString(fhirObject.getText());
        if (fhirText.isPresent()) {
            localObject.setText(fhirText.get());
        } else {
            localObject.setText("");
        }
        localObject.setCategory(this.accessor.getCategory((DomainResource)fhirObject));
        this.findingsService.saveFinding((IFinding)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IAllergyIntolerance> createLocalObject(AllergyIntolerance fhirObject) {
        IAllergyIntolerance IallergyIntolerance = (IAllergyIntolerance)this.findingsService.create(IAllergyIntolerance.class);
        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)IallergyIntolerance);
        if (fhirObject.getPatient() != null && fhirObject.getPatient().hasReference()) {
            String id = fhirObject.getPatient().getReferenceElement().getIdPart();
            Optional patient = this.modelService.load(id, IPatient.class);
            patient.ifPresent(k -> IallergyIntolerance.setPatientId(id));
        }
        this.findingsService.saveFinding((IFinding)IallergyIntolerance);
        return Optional.of(IallergyIntolerance);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return AllergyIntolerance.class.equals(fhirClazz) && IAllergyIntolerance.class.equals(localClazz);
    }
}

