/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;

public class VisibleCodingsSelectionDialog
extends TitleAreaDialog {
    private List<ICoding> available;
    private CheckboxTableViewer viewer;
    private List<ICoding> selected;
    private Font boldFont;

    public VisibleCodingsSelectionDialog(Shell parentShell, List<ICoding> available) {
        super(parentShell);
        this.available = available;
    }

    public void create() {
        super.create();
        this.setTitle("Sichtbare Befunde Codes ausw\u00e4hlen.");
        this.setMessage("Definiert welche Codes bei der Ansicht der Werte zur Auswahl stehen.\nWenn kein Code ausgew\u00e4hlt ist, stehen alle zu Auswahl.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new GridLayout());
        ToolBarManager mgr = new ToolBarManager();
        mgr.add((IAction)new Action("Gruppen selektieren"){

            public void run() {
                List groups = VisibleCodingsSelectionDialog.this.available.stream().filter(c -> FindingsUiUtil.isCodingForGroup(c)).collect(Collectors.toList());
                VisibleCodingsSelectionDialog.this.viewer.setAllChecked(false);
                for (ICoding iCoding : groups) {
                    VisibleCodingsSelectionDialog.this.viewer.setChecked((Object)iCoding, true);
                }
                VisibleCodingsSelectionDialog.this.selected = groups;
            }
        });
        ToolBar toolbar = mgr.createControl(ret);
        toolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Table table = new Table(ret, 34);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.boldFont = this.createBoldFont(table.getFont());
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setInput(this.available);
        for (ICoding iCoding : this.selected) {
            this.viewer.setChecked((Object)iCoding, true);
        }
        return ret;
    }

    protected void okPressed() {
        this.selected = Arrays.asList(this.viewer.getCheckedElements()).stream().map(c -> (ICoding)c).collect(Collectors.toList());
        super.okPressed();
    }

    public void setSelected(List<ICoding> selected) {
        this.selected = selected;
    }

    public List<ICoding> getSelected() {
        return this.selected;
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), fd.getHeight(), fd.getStyle() | 1);
        return font;
    }

    protected boolean isResizable() {
        return true;
    }

    private class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableFontProvider {
        private LabelProvider() {
        }

        public String getText(Object element) {
            ICoding iCoding = (ICoding)element;
            return iCoding != null ? iCoding.getDisplay() + " (" + iCoding.getCode() + ")" : "";
        }

        public Font getFont(Object element, int columnIndex) {
            if (FindingsUiUtil.isCodingForGroup((ICoding)element)) {
                return VisibleCodingsSelectionDialog.this.boldFont;
            }
            return null;
        }
    }
}

