/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.FilterNonPrintableModifyListener;
import ch.elexis.core.ui.util.NatTableFactory;
import ch.elexis.core.ui.util.NatTableWrapper;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class NoteListComposite
extends Composite {
    private NatTableWrapper natTableWrapper;
    private ToolBarManager toolbarManager;
    private Label title;
    private EventList<String> dataList = new BasicEventList();
    private NotesAdapter adapter;

    public NoteListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.title = new Label((Composite)this, 0);
        this.title.setText("Notizen:");
        this.title.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.title.setVisible(false);
        this.toolbarManager = new ToolBarManager();
        this.toolbarManager.add((IAction)new AddNoteAction());
        this.toolbarManager.add((IAction)new RemoveNoteAction());
        ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolbar.setBackground(parent.getBackground());
        this.natTableWrapper = NatTableFactory.createSingleColumnTable((Composite)this, (IRowDataProvider)new GlazedListsDataProvider(this.dataList, (IColumnAccessor)new IColumnAccessor<String>(){

            public int getColumnCount() {
                return 1;
            }

            public Object getDataValue(String note, int columnIndex) {
                return note;
            }

            public void setDataValue(String note, int arg1, Object arg2) {
            }
        }), null);
        GridData tableGd = new GridData(1808);
        tableGd.horizontalSpan = 2;
        this.natTableWrapper.getNatTable().setLayoutData((Object)tableGd);
    }

    public void setInput(NotesAdapter adapter) {
        this.adapter = adapter;
        this.dataList.clear();
        this.dataList.addAll(adapter.getNotes());
        this.natTableWrapper.getNatTable().refresh();
    }

    public void showTitle(boolean value) {
        this.title.setVisible(value);
        this.layout();
    }

    private class AddNoteAction
    extends Action {
        private AddNoteAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public String getText() {
            return "hinzuf\u00fcgen";
        }

        public void run() {
            InputDialog input = new InputDialog(NoteListComposite.this.getShell(), "Notiz", "Notiz erfassen", "", null);
            if (input.open() == 0 && input.getValue() != null && !input.getValue().isEmpty()) {
                String filteredInput = FilterNonPrintableModifyListener.filterNonPrintable((String)input.getValue());
                NoteListComposite.this.adapter.addNote(filteredInput);
                NoteListComposite.this.dataList.add((Object)filteredInput);
                NoteListComposite.this.natTableWrapper.getNatTable().refresh();
            }
        }
    }

    public static interface NotesAdapter {
        public List<String> getNotes();

        public void addNote(String var1);

        public void removeNote(String var1);
    }

    private class RemoveNoteAction
    extends Action {
        private RemoveNoteAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getText() {
            return "entfernen";
        }

        public void run() {
            ISelection selection = NoteListComposite.this.natTableWrapper.getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                List list = ((StructuredSelection)selection).toList();
                list.stream().forEach(note -> {
                    NoteListComposite.this.adapter.removeNote((String)note);
                    NoteListComposite.this.dataList.remove(note);
                });
                NoteListComposite.this.natTableWrapper.getNatTable().refresh();
            }
        }
    }
}

