/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.dialogs.AllergyIntoleranceEditDialog;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.NatTableFactory;
import ch.elexis.core.ui.util.NatTableWrapper;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Patient;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class AllergyIntoleranceListComposite
extends Composite {
    private NatTableWrapper natTableWrapper;
    private ToolBarManager toolbarManager;
    private EventList<IAllergyIntolerance> dataList = new BasicEventList();
    private boolean macosx_swt_eventTimed = false;

    public AllergyIntoleranceListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.natTableWrapper = NatTableFactory.createSingleColumnTable((Composite)this, (IRowDataProvider)new GlazedListsDataProvider(this.dataList, (IColumnAccessor)new IColumnAccessor<IAllergyIntolerance>(){

            public int getColumnCount() {
                return 1;
            }

            public Object getDataValue(IAllergyIntolerance condition, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.getFormattedDescriptionText(condition);
                    }
                }
                return "";
            }

            private Object getFormattedDescriptionText(IAllergyIntolerance allergy) {
                StringBuilder text = new StringBuilder();
                StringBuilder contentText = new StringBuilder();
                Optional allergyText = allergy.getText();
                allergyText.ifPresent(t -> {
                    if (contentText.length() > 0) {
                        contentText.append("\n");
                    }
                    contentText.append((String)t);
                });
                Optional<ICoding> substanceCode = allergy.getCoding().stream().filter(c -> c.getSystem() != null && c.getSystem().toLowerCase().contains("substance")).findFirst();
                if (substanceCode.isPresent()) {
                    if (contentText.length() > 0) {
                        contentText.append("\n");
                    }
                    contentText.append(substanceCode.get().getDisplay());
                }
                text.append(contentText.toString());
                return text.toString().replaceAll("\n", "<br/>");
            }

            public void setDataValue(IAllergyIntolerance condition, int arg1, Object arg2) {
            }
        }), null);
        this.natTableWrapper.getNatTable().setLayoutData((Object)new GridData(1808));
        this.natTableWrapper.addDoubleClickListener(new NatTableWrapper.IDoubleClickListener(){

            public void doubleClick(final NatTableWrapper source, ISelection selection) {
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    final IAllergyIntolerance condition = (IAllergyIntolerance)((StructuredSelection)selection).getFirstElement();
                    AcquireLockBlockingUi.aquireAndRun((Identifiable)condition, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            AllergyIntoleranceEditDialog dialog = new AllergyIntoleranceEditDialog(condition, Display.getDefault().getActiveShell());
                            if (dialog.open() == 0) {
                                dialog.getAllergyIntolerance().ifPresent(c -> source.getNatTable().refresh());
                            }
                        }
                    });
                }
            }
        });
        this.toolbarManager = new ToolBarManager();
        this.toolbarManager.add((IAction)new AddConditionAction());
        this.toolbarManager.add((IAction)new RemoveConditionAction());
        ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolbar.setBackground(parent.getBackground());
    }

    public void setInput(List<IAllergyIntolerance> conditions) {
        this.dataList.clear();
        conditions.sort(new Comparator<IAllergyIntolerance>(){

            @Override
            public int compare(IAllergyIntolerance left, IAllergyIntolerance right) {
                Optional lrecorded = left.getDateRecorded();
                Optional rrecorded = right.getDateRecorded();
                if (lrecorded.isPresent() && rrecorded.isPresent()) {
                    return ((LocalDate)rrecorded.get()).compareTo((ChronoLocalDate)lrecorded.get());
                }
                return 0;
            }
        });
        this.dataList.addAll(conditions);
        this.natTableWrapper.getNatTable().refresh();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point ret = this.toolbarManager.getControl().computeSize(wHint, hHint);
        Point natRet = this.natTableWrapper.computeSize(wHint, hHint);
        ret.y += natRet.y;
        ret.x = natRet.x;
        return ret;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.natTableWrapper != null && !this.natTableWrapper.isDisposed()) {
            this.natTableWrapper.getNatTable().setBackground(color);
        }
    }

    public void redraw() {
        super.redraw();
        if (CoreUtil.isMac()) {
            if (this.macosx_swt_eventTimed) {
                return;
            }
            this.macosx_swt_eventTimed = true;
            this.getDisplay().timerExec(250, new Runnable(){

                @Override
                public void run() {
                    AllergyIntoleranceListComposite.this.natTableWrapper.getNatTable().redraw();
                    AllergyIntoleranceListComposite.this.macosx_swt_eventTimed = false;
                }
            });
        }
    }

    private class AddConditionAction
    extends Action {
        private AddConditionAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public String getText() {
            return "erstellen";
        }

        public void run() {
            AllergyIntoleranceEditDialog dialog;
            Patient selectedPatient = ElexisEventDispatcher.getSelectedPatient();
            if (selectedPatient != null && (dialog = new AllergyIntoleranceEditDialog(IAllergyIntolerance.AllergyIntoleranceCategory.UNKNOWN, AllergyIntoleranceListComposite.this.getShell())).open() == 0) {
                dialog.getAllergyIntolerance().ifPresent(c -> {
                    c.setPatientId(selectedPatient.getId());
                    FindingsServiceComponent.getService().saveFinding((IFinding)c);
                    LocalLockServiceHolder.get().acquireLock(c);
                    AllergyIntoleranceListComposite.this.dataList.add(c);
                    AllergyIntoleranceListComposite.this.natTableWrapper.getNatTable().refresh();
                });
            }
        }
    }

    private class RemoveConditionAction
    extends Action {
        private RemoveConditionAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getText() {
            return "entfernen";
        }

        public void run() {
            ISelection selection = AllergyIntoleranceListComposite.this.natTableWrapper.getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                List list = ((StructuredSelection)selection).toList();
                list.stream().forEach(c -> AcquireLockUi.aquireAndRun((Identifiable)c, (ILockHandler)new ILockHandler((IAllergyIntolerance)c){
                    private final /* synthetic */ IAllergyIntolerance val$c;
                    {
                        this.val$c = iAllergyIntolerance;
                    }

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        FindingsServiceComponent.getService().deleteFinding((IFinding)this.val$c);
                        ((RemoveConditionAction)RemoveConditionAction.this).AllergyIntoleranceListComposite.this.dataList.remove((Object)this.val$c);
                        ((RemoveConditionAction)RemoveConditionAction.this).AllergyIntoleranceListComposite.this.natTableWrapper.getNatTable().refresh();
                    }
                }));
            }
        }
    }
}

