/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.composites.ConditionComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import java.util.Optional;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConditionEditDialog
extends TitleAreaDialog {
    private ConditionComposite conditionComposite;
    private Optional<ICondition> condition = Optional.empty();
    private ICondition.ConditionCategory category;

    public ConditionEditDialog(ICondition.ConditionCategory category, Shell parentShell) {
        super(parentShell);
        this.category = category;
        this.setShellStyle(2160);
    }

    public ConditionEditDialog(ICondition condition, Shell parentShell) {
        super(parentShell);
        this.condition = Optional.of(condition);
        this.category = condition.getCategory();
        this.setShellStyle(2160);
    }

    public void create() {
        super.create();
        this.setTitle(this.category.getLocalized() + " Daten " + (this.condition.isPresent() ? "editieren" : "anlegen") + ".");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new FillLayout());
        this.conditionComposite = new ConditionComposite(this.category, ret, 0);
        this.condition.ifPresent(c -> this.conditionComposite.setCondition((ICondition)c));
        return ret;
    }

    protected void okPressed() {
        this.condition = this.conditionComposite.getCondition();
        FindingsServiceComponent.getService().saveFinding((IFinding)this.condition.get());
        super.okPressed();
    }

    public Optional<ICondition> getCondition() {
        return this.condition;
    }
}

