/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dbcheck;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationsCleanup
extends ExternalMaintenance {
    private static Logger logger = LoggerFactory.getLogger(ObservationsCleanup.class);
    private int deletedCount = 0;
    private int allCount = 0;
    private IFindingsService findingsService;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        List allPatients = new Query(Patient.class).execute();
        this.deletedCount = 0;
        this.allCount = 0;
        this.findingsService = FindingsServiceComponent.getService();
        pm.beginTask("Mehrfache und leere Observations (Befunde) entfernen", allPatients.size());
        for (Patient patient : allPatients) {
            List<IObservation> observations = this.findingsService.getPatientsFindings(patient.getId(), IObservation.class);
            observations = this.filterVitalSigns(observations);
            observations = this.removeNoCodeObservations(observations);
            Map<String, List<IObservation>> groupedObservations = this.groupObservations(observations);
            for (String key : groupedObservations.keySet()) {
                List<IObservation> matchingObservations = groupedObservations.get(key);
                this.allCount += matchingObservations.size();
                if (matchingObservations.size() <= 1) continue;
                int i = 1;
                while (i < matchingObservations.size()) {
                    logger.info("Deleting duplicate observation " + key + " pat [" + patient.getPatCode() + "]");
                    this.findingsService.deleteFinding((IFinding)matchingObservations.get(i));
                    ++this.deletedCount;
                    ++i;
                }
            }
            pm.worked(1);
        }
        return this.deletedCount + " Observations wurden entfernt.\n " + this.allCount + " Observations insgesamt.";
    }

    private List<IObservation> filterVitalSigns(List<IObservation> observations) {
        ArrayList<IObservation> ret = new ArrayList<IObservation>();
        for (IObservation iObservation : observations) {
            if (iObservation.getCategory() != IObservation.ObservationCategory.VITALSIGNS) continue;
            ret.add(iObservation);
        }
        return ret;
    }

    private List<IObservation> removeNoCodeObservations(List<IObservation> observations) {
        ArrayList<IObservation> ret = new ArrayList<IObservation>();
        for (IObservation iObservation : observations) {
            if (iObservation.getCoding() == null || iObservation.getCoding().isEmpty()) {
                logger.info("Deleting observation without code - " + String.valueOf(iObservation));
                this.findingsService.deleteFinding((IFinding)iObservation);
                ++this.deletedCount;
                continue;
            }
            ret.add(iObservation);
        }
        return ret;
    }

    private Map<String, List<IObservation>> groupObservations(List<IObservation> observations) {
        HashMap<String, List<IObservation>> ret = new HashMap<String, List<IObservation>>();
        for (IObservation iObservation : observations) {
            String key = "[" + iObservation.getEffectiveTime().toString() + "][" + ((ICoding)iObservation.getCoding().get(0)).getSystem() + "#" + ((ICoding)iObservation.getCoding().get(0)).getCode() + "][" + iObservation.getText().orElse("") + "]";
            ArrayList<IObservation> list = (ArrayList<IObservation>)ret.get(key);
            if (list == null) {
                list = new ArrayList<IObservation>();
            }
            list.add(iObservation);
            ret.put(key, list);
        }
        return ret;
    }

    public String getMaintenanceDescription() {
        return "Mehrfache und leere Observations (Befunde) entfernen.";
    }
}

