/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.composite;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.ui.composite.FindingsDetailComposite;
import ch.elexis.core.findings.templates.ui.dlg.FindingsDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.findings.templates.ui.util.FindingsTemplateUtil;
import ch.elexis.core.ui.icons.Images;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class FindingsComposite
extends Composite {
    private FindingsDetailComposite findingsDetailComposite;
    private TreeViewer viewer;
    private FindingsTemplates model;

    public FindingsComposite(Composite parent, FindingsTemplates model) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.model = model;
    }

    public void createContents() {
        this.viewer = new TreeViewer((Composite)this, 67584);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.viewer.setContentProvider((IContentProvider)new FindingsTemplateContentProvider((AdapterFactory)composedAdapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new FindingsTemplateLabelProvider((AdapterFactory)composedAdapterFactory));
        ResourceImpl r = new ResourceImpl();
        r.getContents().add((Object)this.model);
        this.createContextMenu((Viewer)this.viewer);
        this.viewer.setInput((Object)r);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Optional<FindingsTemplates> model = FindingsComposite.this.getModel();
                if (model.isPresent() && event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection s = (StructuredSelection)event.getSelection();
                    Object element = s.getFirstElement();
                    FindingsComposite.this.findingsDetailComposite.setSelection(model.get(), element instanceof FindingsTemplate ? (FindingsTemplate)s.getFirstElement() : null);
                }
            }
        });
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFindingsDetailComposite(FindingsDetailComposite findingsDetailComposite) {
        this.findingsDetailComposite = findingsDetailComposite;
    }

    public Optional<FindingsTemplates> getModel() {
        Resource r = (Resource)this.viewer.getInput();
        if (r != null && !r.getContents().isEmpty()) {
            return Optional.of((FindingsTemplates)r.getContents().get(0));
        }
        return Optional.empty();
    }

    public void selectFirstTreeElement() {
        if (this.model != null && !this.model.getFindingsTemplates().isEmpty()) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.model.getFindingsTemplates().get(0)));
        }
    }

    public void setModel(FindingsTemplates model, boolean selectFirst) {
        ResourceImpl r = new ResourceImpl();
        r.getContents().add((Object)model);
        this.viewer.setInput((Object)r);
        this.viewer.expandToLevel(2);
        if (selectFirst) {
            this.selectFirstTreeElement();
        }
    }

    private void createContextMenu(final Viewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection.getFirstElement() instanceof FindingsTemplate) {
                    FindingsComposite.this.fillContextMenu(mgr, (FindingsTemplate)selection.getFirstElement());
                } else if (selection.getFirstElement() instanceof FindingsTemplates) {
                    FindingsComposite.this.fillContextMenu(mgr, (FindingsTemplates)selection.getFirstElement());
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager contextMenu, final FindingsTemplate findingsTemplate) {
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action("Entfernen"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                if (FindingsComposite.this.getModel().isPresent()) {
                    EcoreUtil.delete((EObject)findingsTemplate);
                    FindingsComposite.this.getViewer().refresh();
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager contextMenu, final FindingsTemplates findingsTemplates) {
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action("Neue Vorlage"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                FindingsDialog findingsDialog = new FindingsDialog(Display.getDefault().getActiveShell(), findingsTemplates);
                if (findingsDialog.open() == 0) {
                    FindingsComposite.this.viewer.expandToLevel(2);
                }
            }
        });
        contextMenu.add((IAction)new Action("Vorlage Entfernen"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                if (findingsTemplates instanceof FindingsTemplates && MessageDialog.openQuestion((Shell)FindingsComposite.this.getShell(), (String)"Vorlagen L\u00f6schen", (String)"Wollen Sie wirklich diese Vorlage und alle untergeordneten Vorlagen l\u00f6schen ?")) {
                    findingsTemplates.getFindingsTemplates().clear();
                }
            }
        });
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action("Vorlagen Importieren"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_IMPORT.getImageDescriptor();
            }

            public void run() {
                FileDialog dialog = new FileDialog(FindingsComposite.this.getShell(), 4096);
                dialog.setFilterNames(new String[]{"xml"});
                dialog.setFilterExtensions(new String[]{"*.xml"});
                dialog.setFilterPath(CoreHub.getWritableUserDir().getAbsolutePath());
                String path = dialog.open();
                if (path != null) {
                    try {
                        FindingsTemplates findingsTemplates = FindingsServiceHolder.findingsTemplateService.importTemplateFromFile(path);
                        if (findingsTemplates != null) {
                            FindingsComposite.this.model = findingsTemplates;
                            FindingsComposite.this.setModel(FindingsComposite.this.model, true);
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(FindingsComposite.class).error("findings template import error", (Throwable)e);
                        MessageDialog.openError((Shell)FindingsComposite.this.getShell(), (String)"Fehler", (String)("Vorlagen Import nicht m\u00f6glich. [" + e.getMessage() + "]"));
                    }
                }
            }
        });
        contextMenu.add((IAction)new Action("Vorlagen Exportieren"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EXPORT.getImageDescriptor();
            }

            public void run() {
                FileDialog dialog = new FileDialog(FindingsComposite.this.getShell(), 8192);
                dialog.setFilterNames(new String[]{"xml"});
                dialog.setFilterExtensions(new String[]{"*.xml"});
                dialog.setOverwrite(true);
                dialog.setFilterPath(CoreHub.getWritableUserDir().getAbsolutePath());
                dialog.setFileName("befundvorlage_" + System.currentTimeMillis() + ".xml");
                String path = dialog.open();
                if (path != null) {
                    try {
                        FindingsServiceHolder.findingsTemplateService.exportTemplateToFile(FindingsComposite.this.model, path);
                        FindingsComposite.this.model = FindingsServiceHolder.findingsTemplateService.getFindingsTemplates("Standard Vorlagen");
                        FindingsComposite.this.setModel(FindingsComposite.this.model, true);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(FindingsComposite.class).error("findings template export error", (Throwable)e);
                        MessageDialog.openError((Shell)FindingsComposite.this.getShell(), (String)"Fehler", (String)("Vorlagen Export nicht m\u00f6glich. [" + e.getMessage() + "]"));
                    }
                }
            }
        });
    }

    class FindingsTemplateContentProvider
    extends AdapterFactoryContentProvider {
        public FindingsTemplateContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public boolean hasChildren(Object object) {
            FindingsTemplate findingsTemplate;
            if (object instanceof FindingsTemplates) {
                return super.hasChildren(object);
            }
            if (object instanceof FindingsTemplate && (findingsTemplate = (FindingsTemplate)object).getInputData() instanceof InputDataGroupComponent) {
                InputDataGroupComponent inputDataGroupComponent = (InputDataGroupComponent)findingsTemplate.getInputData();
                return !inputDataGroupComponent.getFindingsTemplates().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object object) {
            FindingsTemplate findingsTemplate;
            if (object instanceof FindingsTemplates) {
                return super.getChildren(object);
            }
            if (object instanceof FindingsTemplate && (findingsTemplate = (FindingsTemplate)object).getInputData() instanceof InputDataGroupComponent) {
                InputDataGroupComponent inputDataGroupComponent = (InputDataGroupComponent)findingsTemplate.getInputData();
                return inputDataGroupComponent.getFindingsTemplates().toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }
    }

    class FindingsTemplateLabelProvider
    extends AdapterFactoryLabelProvider {
        public FindingsTemplateLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getImage(Object object) {
            Image img = FindingsTemplateUtil.getImage(object);
            return img != null ? img : super.getImage(object);
        }
    }
}

