/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public abstract class AbstractFindingModelAdapter<T extends EntityWithId>
extends AbstractIdDeleteModelAdapter<T>
implements IFinding {
    public AbstractFindingModelAdapter(T entity) {
        super(entity);
    }

    protected void saveResource(IBaseResource resource) {
        ModelUtil.saveResource((IBaseResource)resource, (IFinding)this);
    }

    protected Optional<IBaseResource> loadResource() {
        return ModelUtil.loadResource((IFinding)this);
    }

    public Optional<String> getText() {
        Narrative narrative;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource && (narrative = ((DomainResource)resource.get()).getText()) != null && narrative.getDivAsString() != null) {
            return ModelUtil.getNarrativeAsString((Narrative)narrative);
        }
        return Optional.empty();
    }

    public void setText(String text) {
        text = this.filterNonPrintable(text);
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            DomainResource domainResource = (DomainResource)resource.get();
            Narrative narrative = domainResource.getText();
            if (narrative == null) {
                narrative = new Narrative();
            }
            ModelUtil.setNarrativeFromString((Narrative)narrative, (String)text);
            domainResource.setText(narrative);
            this.saveResource((IBaseResource)domainResource);
        }
    }

    public void addStringExtension(String theUrl, String theValue) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            DomainResource domainResource = (DomainResource)resource.get();
            Extension extension = new Extension(theUrl);
            extension.setValue((Type)new StringType().setValue((Object)theValue));
            domainResource.addExtension(extension);
            this.saveResource((IBaseResource)domainResource);
        }
    }

    public Map<String, String> getStringExtensions() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            List extensions = ((DomainResource)resource.get()).getExtension();
            return extensions.stream().filter(extension -> extension.getValue() instanceof StringType).collect(Collectors.toMap(extension -> extension.getUrl(), extension -> ((StringType)extension.getValue()).getValueAsString()));
        }
        return Collections.emptyMap();
    }

    private String filterNonPrintable(String input) {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            return input.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "");
        }
        return input;
    }
}

