/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.fhir.model.service;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import ca.uhn.fhir.rest.gclient.IQuery;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.exceptions.AccessControlException;
import ch.elexis.core.fhir.model.IFhirModelService;
import ch.elexis.core.fhir.model.adapter.ElexisTypeMap;
import ch.elexis.core.fhir.model.adapter.ModelAdapterFactory;
import ch.elexis.core.fhir.model.impl.AbstractFhirModelAdapter;
import ch.elexis.core.fhir.model.service.CustomOkHttpRestfulClientFactory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.IStoreToStringContribution;
import ch.elexis.core.utils.CoreUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class FhirModelService
implements IFhirModelService,
IStoreToStringContribution {
    private static FhirContext context = FhirContext.forR4();
    @Reference
    private IElexisServerService elexisServer;
    @Reference
    private IContextService contextService;
    private IGenericClient client;
    private ModelAdapterFactory adapterFactory;

    @Activate
    public void activate() {
        this.adapterFactory = new ModelAdapterFactory();
    }

    private IGenericClient getGenericClient() {
        if (this.client == null) {
            context.setRestfulClientFactory((IRestfulClientFactory)new CustomOkHttpRestfulClientFactory(context));
            this.client = context.newRestfulGenericClient(this.elexisServer.getConnectionUrl().replace("/services", "/fhir"));
            if (CoreUtil.isTestMode()) {
                LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
                loggingInterceptor.setLogRequestSummary(true);
                loggingInterceptor.setLogRequestBody(true);
                this.client.registerInterceptor((Object)loggingInterceptor);
            }
            this.contextService.getTyped(AccessToken.class).ifPresent(accessToken -> {
                BearerTokenAuthInterceptor authInterceptor = new BearerTokenAuthInterceptor(accessToken.getToken());
                this.client.registerInterceptor((Object)authInterceptor);
            });
        }
        return this.client;
    }

    @Override
    public <T> T create(Class<T> clazz) throws AccessControlException {
        return null;
    }

    @Override
    public <T> Optional<T> adapt(Object fhirObject, Class<T> clazz) {
        Identifiable adapter = this.adapterFactory.createAdapter((BaseResource)fhirObject);
        if (adapter != null && clazz.isAssignableFrom(adapter.getClass())) {
            return Optional.of(adapter);
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> load(String id, Class<T> clazz, boolean includeDeleted) throws AccessControlException {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            try {
                BaseResource fhirObject = (BaseResource)this.getGenericClient().read().resource(this.adapterFactory.getFhirType(clazz)).withId(id).execute();
                if (fhirObject != null) {
                    return this.adapt(fhirObject, clazz);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).warn(e.getMessage());
            }
        }
        return Optional.empty();
    }

    @Override
    public void save(Identifiable identifiable) throws AccessControlException {
        if (identifiable instanceof AbstractFhirModelAdapter) {
            this.getGenericClient().update().resource(((AbstractFhirModelAdapter)identifiable).getFhirResource()).execute();
        }
    }

    @Override
    public void save(List<? extends Identifiable> identifiables) throws AccessControlException {
        if (identifiables != null) {
            identifiables.stream().forEach(i -> this.save((Identifiable)i));
        }
    }

    @Override
    public void delete(Identifiable identifiable) throws AccessControlException {
        if (identifiable instanceof AbstractFhirModelAdapter) {
            this.getGenericClient().delete().resource(((AbstractFhirModelAdapter)identifiable).getFhirResource()).execute();
        }
    }

    @Override
    public void delete(List<? extends Identifiable> identifiables) throws AccessControlException {
        if (identifiables != null) {
            identifiables.stream().forEach(i -> this.delete((Identifiable)i));
        }
    }

    @Override
    public void postEvent(String topic, Object object) {
    }

    @Override
    public IElexisServerService.ConnectionStatus getConnectionStatus() {
        IElexisServerService.ConnectionStatus status = this.elexisServer.getConnectionStatus();
        if (status != null) {
            if (CoreUtil.isTestMode() || this.elexisServer.getConnectionUrl() == null || this.elexisServer.getConnectionUrl().contains("localhost")) {
                return status;
            }
            Optional accessToken = this.contextService.getTyped(AccessToken.class);
            if (accessToken.isPresent()) {
                return status;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Elexis Server connected but no access token available");
        }
        return IElexisServerService.ConnectionStatus.LOCAL;
    }

    @Override
    public <T> List<T> getQueryResults(IQuery<IBaseBundle> query, Class<T> clazz) {
        Bundle results = (Bundle)query.returnBundle(Bundle.class).execute();
        if (results != null && results.hasEntry()) {
            return results.getEntry().stream().filter(e -> e.hasResource()).map(e -> this.adapt(e.getResource(), clazz).orElse(null)).filter(i -> i != null).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public <T> IQuery<IBaseBundle> getQuery(Class<T> clazz) {
        return this.getGenericClient().search().forResource(this.adapterFactory.getFhirType(clazz));
    }

    @Override
    public IQuery<IBaseBundle> getQuery(String byUrl) {
        return this.getGenericClient().search().byUrl(byUrl);
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        AbstractFhirModelAdapter fhirModelAdapter;
        String classKey;
        if (identifiable instanceof AbstractFhirModelAdapter && (classKey = ElexisTypeMap.getKeyForObject(fhirModelAdapter = (AbstractFhirModelAdapter)identifiable)) != null) {
            return Optional.of(classKey + "::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        return Optional.empty();
    }

    public Class<?> getEntityForType(String type) {
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        return null;
    }
}

