/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.fhir.model.impl;

import ch.elexis.core.fhir.model.impl.AbstractFhirModelAdapter;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.model.IAddress;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.StringType;

public class FhirPatient
extends AbstractFhirModelAdapter<Patient>
implements IPatient {
    public FhirPatient(Patient fhirResource) {
        super(fhirResource);
    }

    public IContact getFamilyDoctor() {
        return null;
    }

    public void setFamilyDoctor(IContact value) {
    }

    public String getDiagnosen() {
        return null;
    }

    public void setDiagnosen(String value) {
    }

    public String getRisk() {
        return null;
    }

    public void setRisk(String value) {
    }

    public String getFamilyAnamnese() {
        return null;
    }

    public void setFamilyAnamnese(String value) {
    }

    public String getPersonalAnamnese() {
        return null;
    }

    public void setPersonalAnamnese(String value) {
    }

    public String getAllergies() {
        return null;
    }

    public void setAllergies(String value) {
    }

    public List<ICoverage> getCoverages() {
        return null;
    }

    public String getPatientNr() {
        return ((Patient)this.getFhirResource()).getIdentifier().stream().filter(i -> IdentifierSystem.ELEXIS_PATNR.getSystem().equals(i.getSystem())).map(i -> i.getValue()).findAny().orElse(null);
    }

    public void setPatientNr(String patientNr) {
        Identifier identifier = FhirUtil.getOrCreateIdentifier((String)IdentifierSystem.ELEXIS_PATNR.getSystem(), (Patient)((Patient)this.getFhirResource()));
        identifier.setValue(patientNr);
    }

    public List<IPrescription> getMedication(List<EntryType> filterType) {
        return null;
    }

    public LocalDateTime getDateOfBirth() {
        if (((Patient)this.getFhirResource()).getBirthDate() != null) {
            return LocalDateTime.ofInstant(((Patient)this.getFhirResource()).getBirthDate().toInstant(), ZoneId.systemDefault());
        }
        return null;
    }

    public void setDateOfBirth(LocalDateTime value) {
        if (value != null) {
            ((Patient)this.getFhirResource()).setBirthDate(Date.from(value.atZone(ZoneId.systemDefault()).toInstant()));
        }
        ((Patient)this.getFhirResource()).setBirthDate(null);
    }

    public Gender getGender() {
        if (((Patient)this.getFhirResource()).getGender() != null) {
            switch (((Patient)this.getFhirResource()).getGender()) {
                case FEMALE: {
                    return Gender.FEMALE;
                }
                case MALE: {
                    return Gender.MALE;
                }
                case UNKNOWN: {
                    return Gender.UNKNOWN;
                }
            }
            return Gender.UNDEFINED;
        }
        return Gender.UNDEFINED;
    }

    public void setGender(Gender value) {
        if (value != null) {
            switch (value) {
                case FEMALE: {
                    ((Patient)this.getFhirResource()).setGender(Enumerations.AdministrativeGender.FEMALE);
                    break;
                }
                case MALE: {
                    ((Patient)this.getFhirResource()).setGender(Enumerations.AdministrativeGender.MALE);
                    break;
                }
                case UNDEFINED: {
                    ((Patient)this.getFhirResource()).setGender(Enumerations.AdministrativeGender.OTHER);
                    break;
                }
                case UNKNOWN: {
                    ((Patient)this.getFhirResource()).setGender(Enumerations.AdministrativeGender.UNKNOWN);
                    break;
                }
            }
        }
    }

    public String getTitel() {
        for (HumanName humanName : ((Patient)this.getFhirResource()).getName()) {
            if (((Patient)this.getFhirResource()).getName().size() != 1 && !HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            return humanName.getPrefixAsSingleString();
        }
        return null;
    }

    public void setTitel(String value) {
        if (value != null) {
            ((Patient)this.getFhirResource()).getNameFirstRep().setPrefix(Collections.singletonList(new StringType(value)));
        } else {
            ((Patient)this.getFhirResource()).getNameFirstRep().setPrefix(null);
        }
    }

    public String getTitelSuffix() {
        for (HumanName humanName : ((Patient)this.getFhirResource()).getName()) {
            if (((Patient)this.getFhirResource()).getName().size() != 1 && !HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            return humanName.getSuffixAsSingleString();
        }
        return null;
    }

    public void setTitelSuffix(String value) {
        if (value != null) {
            ((Patient)this.getFhirResource()).getNameFirstRep().setSuffix(Collections.singletonList(new StringType(value)));
        } else {
            ((Patient)this.getFhirResource()).getNameFirstRep().setSuffix(null);
        }
    }

    public String getFirstName() {
        for (HumanName humanName : ((Patient)this.getFhirResource()).getName()) {
            if (((Patient)this.getFhirResource()).getName().size() != 1 && !HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            return humanName.getGivenAsSingleString();
        }
        return null;
    }

    public void setFirstName(String value) {
        if (value != null) {
            ((Patient)this.getFhirResource()).getNameFirstRep().setGiven(Collections.singletonList(new StringType(value)));
        } else {
            ((Patient)this.getFhirResource()).getNameFirstRep().setGiven(null);
        }
    }

    public String getLastName() {
        for (HumanName humanName : ((Patient)this.getFhirResource()).getName()) {
            if (((Patient)this.getFhirResource()).getName().size() != 1 && !HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            return humanName.getFamily();
        }
        return null;
    }

    public void setLastName(String value) {
        ((Patient)this.getFhirResource()).getNameFirstRep().setFamily(value);
    }

    public MaritalStatus getMaritalStatus() {
        return null;
    }

    public void setMaritalStatus(MaritalStatus value) {
    }

    public IContact getLegalGuardian() {
        return null;
    }

    public void setLegalGuardian(IContact value) {
    }

    public LocalDateTime getDateOfDeath() {
        return null;
    }

    public void setDateOfDeath(LocalDateTime value) {
    }

    public int getAgeInYears() {
        LocalDateTime dateOfBirth = this.getDateOfBirth();
        if (dateOfBirth != null) {
            LocalDate now = LocalDate.now();
            long years = ChronoUnit.YEARS.between(dateOfBirth.toLocalDate(), now);
            return (int)years;
        }
        return -1;
    }

    public long getAgeAtIn(LocalDateTime reference, ChronoUnit chronoUnit) {
        return 0L;
    }

    public boolean isMandator() {
        return false;
    }

    public void setMandator(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isUser() {
        return false;
    }

    public void setUser(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isPatient() {
        return true;
    }

    public void setPatient(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isPerson() {
        return true;
    }

    public void setPerson(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isLaboratory() {
        return false;
    }

    public void setLaboratory(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isOrganization() {
        return false;
    }

    public void setOrganization(boolean value) {
        throw new UnsupportedOperationException();
    }

    public String getDescription1() {
        return this.getLastName();
    }

    public void setDescription1(String value) {
        this.setLastName(value);
    }

    public String getDescription2() {
        return this.getFirstName();
    }

    public void setDescription2(String value) {
        this.setFirstName(value);
    }

    public String getDescription3() {
        return null;
    }

    public void setDescription3(String value) {
    }

    public String getCode() {
        return null;
    }

    public void setCode(String value) {
    }

    public Country getCountry() {
        return null;
    }

    public void setCountry(Country value) {
    }

    public String getZip() {
        return null;
    }

    public void setZip(String value) {
    }

    public String getCity() {
        return null;
    }

    public void setCity(String value) {
    }

    public String getStreet() {
        return null;
    }

    public void setStreet(String value) {
    }

    public String getPhone1() {
        return null;
    }

    public void setPhone1(String value) {
    }

    public String getPhone2() {
        return null;
    }

    public void setPhone2(String value) {
    }

    public String getFax() {
        return null;
    }

    public void setFax(String value) {
    }

    public String getEmail() {
        return null;
    }

    public void setEmail(String value) {
    }

    public String getWebsite() {
        return null;
    }

    public void setWebsite(String value) {
    }

    public String getMobile() {
        return null;
    }

    public void setMobile(String value) {
    }

    public String getComment() {
        return null;
    }

    public void setComment(String value) {
    }

    public List<IAddress> getAddress() {
        return null;
    }

    public String getGroup() {
        return null;
    }

    public void setGroup(String value) {
    }

    public String getPostalAddress() {
        return null;
    }

    public void setPostalAddress(String value) {
    }

    public IImage getImage() {
        return null;
    }

    public void setImage(IImage value) {
    }

    public List<IRelatedContact> getRelatedContacts() {
        return null;
    }

    public boolean isDeceased() {
        return false;
    }

    public void setDeceased(boolean value) {
    }

    public String getEmail2() {
        return null;
    }

    public void setEmail2(String value) {
    }

    public IPerson asIPerson() {
        return (IPerson)CoreModelServiceHolder.get().load(this.getId(), IPerson.class).get();
    }

    public IPatient asIPatient() {
        return (IPatient)CoreModelServiceHolder.get().load(this.getId(), IPatient.class).get();
    }

    public IOrganization asIOrganization() {
        return null;
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public void setDeleted(boolean value) {
    }

    public Object getExtInfo(Object key) {
        return null;
    }

    public void setExtInfo(Object key, Object value) {
    }

    public Map<Object, Object> getMap() {
        return null;
    }

    @Override
    public String getLabel() {
        return PersonFormatUtil.getPersonalia((IPerson)this);
    }

    @Override
    public Class<Patient> getFhirType() {
        return Patient.class;
    }

    @Override
    public Class<?> getModelType() {
        return IPatient.class;
    }
}

