/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Rechnung;
import ch.elexis.data.dto.FallDTO;
import ch.elexis.data.dto.InvoiceHistoryEntryDTO;
import ch.elexis.data.dto.KonsultationDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCorrectionDTO {
    private final String id;
    private String invoiceNumber;
    private String newInvoiceNumber;
    private String bemerkung;
    private String receiver;
    private String invoiceStateText;
    private FallDTO fallDTO;
    private String outputText;
    private String betrag;
    private List<KonsultationDTO> konsultationDTOs = new ArrayList<KonsultationDTO>();
    private List<InvoiceHistoryEntryDTO> correctionHistory = new ArrayList<InvoiceHistoryEntryDTO>();
    private List<InvoiceHistoryEntryDTO> cache = new ArrayList<InvoiceHistoryEntryDTO>();
    private List<ElexisException> errors = new ArrayList<ElexisException>();
    private List<IInvoiceCorrectionChanged> invoiceCorrectionChanges = new ArrayList<IInvoiceCorrectionChanged>();
    private boolean openNewInvoice = false;

    public InvoiceCorrectionDTO() {
        this.id = null;
        this.fallDTO = null;
        this.outputText = null;
        this.invoiceNumber = null;
        this.newInvoiceNumber = null;
        this.openNewInvoice = false;
        this.cache.clear();
        this.correctionHistory.clear();
        this.invoiceCorrectionChanges.clear();
        this.errors.clear();
    }

    public InvoiceCorrectionDTO(Rechnung rechnung) {
        InvoiceState invoiceState;
        this.errors.clear();
        this.invoiceCorrectionChanges.clear();
        this.cache.clear();
        this.correctionHistory.clear();
        this.id = rechnung.getId();
        this.invoiceNumber = rechnung.getNr();
        this.bemerkung = rechnung.getBemerkung();
        Fall fall = rechnung.getFall();
        this.fallDTO = fall.getDTO();
        this.outputText = null;
        this.receiver = fall.getPatient().getLabel();
        this.betrag = rechnung.getBetrag().getAmountAsString();
        this.newInvoiceNumber = (String)rechnung.getExtInfoStoredObjectByKey("Rechnungskorrektur");
        this.openNewInvoice = false;
        if (StringUtils.isNotEmpty((CharSequence)rechnung.getNr()) && (invoiceState = rechnung.getInvoiceState()) != null) {
            this.invoiceStateText = invoiceState.getLocaleText();
        }
        for (Konsultation konsultation : rechnung.getKonsultationen()) {
            KonsultationDTO konsultationDTO = new KonsultationDTO(konsultation);
            this.konsultationDTOs.add(konsultationDTO);
            this.errors.addAll(konsultationDTO.getErrors());
        }
    }

    public List<ElexisException> getErrors() {
        return this.errors;
    }

    public void setNewInvoiceNumber(String newInvoiceNumber) {
        this.newInvoiceNumber = newInvoiceNumber;
    }

    public String getNewInvoiceNumber() {
        return this.newInvoiceNumber;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public List<KonsultationDTO> getKonsultationDTOs() {
        return this.konsultationDTOs;
    }

    public String[] getInvoiceDetails() {
        return new String[]{this.invoiceNumber, this.invoiceStateText, this.receiver, this.betrag};
    }

    public String getBemerkung() {
        return this.bemerkung;
    }

    public String getId() {
        return this.id;
    }

    public FallDTO getFallDTO() {
        return this.fallDTO;
    }

    public void setOutputText(String outputText) {
        this.outputText = outputText;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public boolean hasChanges() {
        return !this.cache.isEmpty();
    }

    public InvoiceHistoryEntryDTO getHistoryEntryForLeistungTransferFromCache(IFall fall) {
        if (fall != null && fall.getId() != null) {
            for (InvoiceHistoryEntryDTO invoiceHistoryEntryDTO : this.cache) {
                if (!invoiceHistoryEntryDTO.getOperationType().equals((Object)InvoiceHistoryEntryDTO.OperationType.LEISTUNG_TRANSFER_TO_FALL_KONS) || !(invoiceHistoryEntryDTO.getAdditional() instanceof IFall) || !((IFall)invoiceHistoryEntryDTO.getAdditional()).getId().equals(fall.getId())) continue;
                return invoiceHistoryEntryDTO;
            }
        }
        return null;
    }

    public void addToCache(InvoiceHistoryEntryDTO historyEntryDTO) {
        if (!historyEntryDTO.getOperationType().isMultiAllowed()) {
            this.cache.remove(historyEntryDTO);
        }
        this.informChanged();
        this.cache.add(historyEntryDTO);
    }

    public void updateHistory() {
        this.outputText = null;
        this.correctionHistory.clear();
        if (this.fallDTO != null && this.fallDTO.isChanged()) {
            this.correctionHistory.add(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.FALL_COPY, this.fallDTO, null));
            this.correctionHistory.add(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.FALL_CHANGE, this.fallDTO, null));
            this.correctionHistory.add(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.FALL_KONSULTATION_TRANSER, this.fallDTO, null));
        }
        this.correctionHistory.addAll(this.cache);
        if (!this.correctionHistory.isEmpty()) {
            this.correctionHistory.add(0, new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.RECHNUNG_STORNO, this, null));
            this.correctionHistory.add(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.RECHNUNG_NEW, this, null));
        }
    }

    public List<InvoiceHistoryEntryDTO> getHistory() {
        return this.correctionHistory;
    }

    public boolean isCorrectionSuccess() {
        for (InvoiceHistoryEntryDTO historyEntryDTO : this.correctionHistory) {
            if (Boolean.TRUE.equals(historyEntryDTO.isSuccess())) continue;
            return false;
        }
        return true;
    }

    public void register(IInvoiceCorrectionChanged invoiceCorrectionChanged) {
        this.invoiceCorrectionChanges.add(invoiceCorrectionChanged);
    }

    private void informChanged() {
        for (IInvoiceCorrectionChanged invoiceCorrectionChanged : this.invoiceCorrectionChanges) {
            invoiceCorrectionChanged.changed(this);
        }
    }

    public void setOpenNewInvoice(boolean openNewInvoice) {
        this.openNewInvoice = openNewInvoice;
    }

    public boolean isOpenNewInvoice() {
        return this.openNewInvoice;
    }

    public static interface IInvoiceCorrectionChanged {
        public void changed(InvoiceCorrectionDTO var1);
    }
}

