/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IVerrechnetAdjuster;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.VerrechnetCopy;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Verrechnet
extends PersistentObject {
    public static final String DETAIL = "Detail";
    public static final String SCALE2 = "Scale2";
    public static final String SCALE = "Scale";
    public static final String LEISTG_CODE = "Leistg_code";
    public static final String LEISTG_TXT = "Leistg_txt";
    public static final String KONSULTATION = "Konsultation";
    public static final String PRICE_SELLING = "VK_Preis";
    public static final String SCALE_SELLING = "VK_Scale";
    public static final String SCALE_TP_SELLING = "VK_TP";
    public static final String COST_BUYING = "EK_Kosten";
    public static final String COUNT = "Zahl";
    public static final String CLASS = "Klasse";
    public static final String USERID = "userID";
    public static final String TABLENAME = "LEISTUNGEN";
    public static final String INDICATED = "indicated";
    public static final String VATSCALE = "vat_scale";
    public static final String FLD_EXT_PRESC_ID = "prescriptionId";
    public static final String FLD_EXT_CHANGEDPRICE = "changedPrice";
    private static ArrayList<IVerrechnetAdjuster> adjusters = new ArrayList();

    static {
        Verrechnet.addMapping(TABLENAME, "Konsultation=Behandlung", LEISTG_TXT, LEISTG_CODE, CLASS, COUNT, COST_BUYING, SCALE_TP_SELLING, SCALE_SELLING, PRICE_SELLING, SCALE, SCALE2, "ExtInfo=Detail", USERID);
        List<IConfigurationElement> adjustersConfigurations = Extensions.getExtensions("ch.elexis.core.data.VerrechnungscodeAdjuster");
        for (IConfigurationElement elem : adjustersConfigurations) {
            try {
                Object o = elem.createExecutableExtension("class");
                if (!(o instanceof IVerrechnetAdjuster)) continue;
                adjusters.add((IVerrechnetAdjuster)o);
            }
            catch (CoreException e) {
                ExHandler.handle((Throwable)e);
            }
        }
    }

    public Verrechnet(IVerrechenbar iv, Konsultation kons, int zahl) {
        TimeTool dat = new TimeTool(kons.getDatum());
        Fall fall = kons.getFall();
        int tp = iv.getTP(dat, kons);
        double factor = iv.getFactor(dat, fall);
        long preis = Math.round((double)tp * factor);
        String[] fields = new String[]{KONSULTATION, LEISTG_TXT, LEISTG_CODE, CLASS, COUNT, COST_BUYING, SCALE_TP_SELLING, SCALE_SELLING, PRICE_SELLING, SCALE, SCALE2, USERID};
        String[] values = new String[]{kons.getId(), iv.getText(), iv.getId(), iv.getClass().getName(), Integer.toString(zahl), iv.getKosten(dat).getCentsAsString(), Integer.toString(tp), Double.toString(factor), Long.toString(preis), "100", "100", CoreHub.getLoggedInContact().getId()};
        this.create(null, fields, values);
        if (iv instanceof Artikel) {
            Mandant mandant = ElexisEventDispatcher.getSelectedMandator();
            String storeToString = StoreToStringServiceHolder.getStoreToString((Artikel)iv);
            StockServiceHolder.get().performSingleDisposal(storeToString, 1, mandant != null ? mandant.getId() : null);
        }
        for (IVerrechnetAdjuster adjuster : adjusters) {
            adjuster.adjust(this);
        }
    }

    public void createCopy(Rechnung bill) {
        new VerrechnetCopy(this, bill);
    }

    public String getText() {
        return Verrechnet.checkNull(this.get(LEISTG_TXT));
    }

    public void setText(String text) {
        this.set(LEISTG_TXT, text);
    }

    public double getTPW() {
        return Verrechnet.checkZeroDouble(this.get(SCALE_SELLING));
    }

    public void setPrimaryScaleFactor(double scale) {
        int sca = (int)Math.round(scale * 100.0);
        this.setInt(SCALE, sca);
    }

    public double getPrimaryScaleFactor() {
        int sca = Verrechnet.checkZero(this.get(SCALE));
        if (sca == 0) {
            return 1.0;
        }
        return (double)sca / 100.0;
    }

    public void setSecondaryScaleFactor(double scale) {
        int sca = (int)Math.round(scale * 100.0);
        this.setInt(SCALE2, sca);
    }

    public double getSecondaryScaleFactor() {
        int sca = Verrechnet.checkZero(this.get(SCALE2));
        if (sca == 0) {
            return 1.0;
        }
        return (double)sca / 100.0;
    }

    public void setTP(double tp) {
        this.set(SCALE_TP_SELLING, Long.toString(Math.round(tp)));
    }

    @Deprecated
    public void setPreis(Money m) {
        this.set(PRICE_SELLING, m.getCentsAsString());
    }

    public Money getKosten() {
        return new Money(Verrechnet.checkZero(this.get(COST_BUYING)));
    }

    @Deprecated
    public Money getEffPreis() {
        return new Money(Verrechnet.checkZero(this.get(PRICE_SELLING)));
    }

    public Money getNettoPreis() {
        Money brutto = this.getBruttoPreis();
        brutto.multiply(this.getPrimaryScaleFactor());
        brutto.multiply(this.getSecondaryScaleFactor());
        for (IVerrechnetAdjuster adjuster : adjusters) {
            adjuster.adjustGetNettoPreis(this, brutto);
        }
        return brutto;
    }

    public Money getBruttoPreis() {
        int tp = Verrechnet.checkZero(this.get(SCALE_TP_SELLING));
        Konsultation k = this.getKons();
        Fall fall = k.getFall();
        TimeTool date = new TimeTool(k.getDatum());
        IVerrechenbar v = this.getVerrechenbar();
        double tpw = 1.0;
        if (v != null) {
            tpw = v.getFactor(date, fall);
        }
        return new Money((int)Math.round(tpw * (double)tp));
    }

    public Money getStandardPreis() {
        IVerrechenbar v = this.getVerrechenbar();
        Konsultation k = this.getKons();
        Fall fall = k.getFall();
        TimeTool date = new TimeTool(k.getDatum());
        double factor = 1.0;
        int tp = 0;
        if (v != null) {
            factor = v.getFactor(date, fall);
            tp = v.getTP(date, fall);
        } else {
            tp = Verrechnet.checkZero(this.get(SCALE_TP_SELLING));
        }
        return new Money((int)Math.round(factor * (double)tp));
    }

    public void setStandardPreis() {
        IVerrechenbar v = this.getVerrechenbar();
        Konsultation k = this.getKons();
        Fall fall = k.getFall();
        TimeTool date = new TimeTool(k.getDatum());
        double factor = v.getFactor(date, fall);
        int tp = v.getTP(date, fall);
        long preis = Math.round((double)tp * factor);
        this.set(new String[]{SCALE_SELLING, SCALE_TP_SELLING, PRICE_SELLING}, Double.toString(factor), Integer.toString(tp), Long.toString(preis));
    }

    public Konsultation getKons() {
        return Konsultation.load(this.get(KONSULTATION));
    }

    public int getZahl() {
        return Verrechnet.checkZero(this.get(COUNT));
    }

    public void setZahl(int z) {
        this.set(COUNT, Integer.toString(z));
    }

    public String getCode() {
        IVerrechenbar verrechenbar = this.getVerrechenbar();
        if (verrechenbar == null) {
            return "?";
        }
        return verrechenbar.getCode();
    }

    public void setDetail(String key, String value) {
        Map ext = this.getMap(DETAIL);
        if (value == null) {
            ext.remove(key);
        } else {
            ext.put(key, value);
        }
        this.setMap(DETAIL, ext);
    }

    public String getDetail(String key) {
        Map ext = this.getMap(DETAIL);
        return (String)ext.get(key);
    }

    public void changeAnzahl(int neuAnzahl) {
        int vorher = this.getZahl();
        this.setZahl(neuAnzahl);
        IVerrechenbar vv = this.getVerrechenbar();
        if (vv instanceof Artikel) {
            Mandant mandant = ElexisEventDispatcher.getSelectedMandator();
            Artikel art = (Artikel)vv;
            String artSts = StoreToStringServiceHolder.getStoreToString(art);
            StockServiceHolder.get().performSingleReturn(artSts, vorher, mandant != null ? mandant.getId() : null);
            StockServiceHolder.get().performSingleDisposal(artSts, neuAnzahl, mandant != null ? mandant.getId() : null);
        }
    }

    public IStatus changeAnzahlValidated(int neuAnzahl) {
        int vorher = this.getZahl();
        if (neuAnzahl == vorher) {
            return Status.OK_STATUS;
        }
        Konsultation kons = this.getKons();
        if (neuAnzahl == 0) {
            kons.removeLeistung(this);
            return Status.OK_STATUS;
        }
        int difference = neuAnzahl - vorher;
        if (difference > 0) {
            IVerrechenbar verrechenbar = this.getVerrechenbar();
            int i = 0;
            while (i < difference) {
                Result<IVerrechenbar> result = kons.addLeistung(verrechenbar);
                if (!result.isOK()) {
                    String message = result.getMessages().stream().map((? super T m) -> m.getText()).collect(Collectors.joining(", "));
                    return new Status(4, "ch.elexis.core.data", message);
                }
                ++i;
            }
        } else if (difference < 0) {
            this.changeAnzahl(neuAnzahl);
        }
        return Status.OK_STATUS;
    }

    public boolean isInstance(IVerrechenbar tmpl) {
        String[] res = new String[2];
        this.get(new String[]{CLASS, LEISTG_CODE}, res);
        return tmpl.getClass().getName().equals(res[0]) && tmpl.getId().equals(res[1]);
    }

    public IVerrechenbar getVerrechenbar() {
        String[] res = new String[2];
        this.get(new String[]{CLASS, LEISTG_CODE}, res);
        try {
            return (IVerrechenbar)((Object)CoreHub.poFactory.createFromString(res[0] + "::" + res[1]));
        }
        catch (Exception ex) {
            log.error("Fehlerhafter Leistungscode " + this.getLabel());
            return null;
        }
    }

    @Override
    public String getLabel() {
        return Verrechnet.checkNull(this.get(LEISTG_TXT));
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static Verrechnet load(String id) {
        return new Verrechnet(id);
    }

    protected Verrechnet() {
    }

    protected Verrechnet(String id) {
        super(id);
    }

    public boolean isChangedPrice() {
        String value = this.getDetail(FLD_EXT_CHANGEDPRICE);
        if (value != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }
}

