/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.nopo.adapter.ArtikelAdapter;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.Constants;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.prescription.Methods;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.data.Anwender;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rezept;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class Prescription
extends PersistentObject {
    public static final String FLD_DATE_UNTIL = "DateUntil";
    public static final String FLD_DATE_FROM = "DateFrom";
    public static final String FLD_COUNT = "Anzahl";
    public static final String FLD_REMARK = "Bemerkung";
    public static final String FLD_DOSAGE = "Dosis";
    public static final String FLD_REZEPT_ID = "RezeptID";
    public static final String FLD_ARTICLE_ID = "ArtikelID";
    public static final String FLD_ARTICLE = "Artikel";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_EXT_TERMS = "terms";
    public static final String FLD_DATE_PRESC = "prescDate";
    public static final String FLD_SORT_ORDER = "sortOrder";
    public static final String FLD_PRESC_TYPE = "prescType";
    public static final String FLD_PRESCRIPTOR = "prescriptor";
    @Deprecated
    public static final String FLD_REZEPTID_VAL_DIREKTABGABE = "Direktabgabe";
    public static final String FLD_EXT_VERRECHNET_ID = "verrechnetId";
    public static final String TABLENAME = "PATIENT_ARTIKEL_JOINT";
    private static final String special_num_at_start = "^(~|)[0-9]/[0-9][ a-zA-Z]*$";

    static {
        Prescription.addMapping(TABLENAME, FLD_PATIENT_ID, FLD_ARTICLE, FLD_ARTICLE_ID, FLD_REZEPT_ID, FLD_DATE_FROM, FLD_DATE_UNTIL, "prescDate=S:D:prescDate", FLD_DOSAGE, FLD_REMARK, FLD_COUNT, FLD_PRESC_TYPE, FLD_SORT_ORDER, "ExtInfo", FLD_PRESCRIPTOR);
    }

    public Prescription(Artikel article, Patient patient, String dosage, String remark) {
        this(article.storeToString(), patient.getId(), dosage, remark);
    }

    public Prescription(String articleStoreToString, String patientId, String dosage, String remark) {
        this.create(null);
        String dateNow = new TimeTool().toString(4);
        IPersistentObject prescriptor = ElexisEventDispatcher.getSelected(Anwender.class);
        this.set(new String[]{FLD_ARTICLE, FLD_PATIENT_ID, FLD_DOSAGE, FLD_REMARK, FLD_DATE_PRESC, FLD_SORT_ORDER, FLD_PRESCRIPTOR}, articleStoreToString, patientId, dosage, remark, dateNow, "999", prescriptor.getId());
        this.setBeginDate(null);
    }

    public Prescription(Prescription other) {
        String[] fields = new String[]{FLD_ARTICLE, FLD_PATIENT_ID, FLD_DOSAGE, FLD_REMARK, FLD_ARTICLE_ID, FLD_PRESC_TYPE};
        String[] vals = new String[fields.length];
        if (other.get(fields, vals)) {
            this.create(null);
            this.set(fields, vals);
            this.setBeginDate(null);
            IPersistentObject prescriptor = ElexisEventDispatcher.getSelected(Anwender.class);
            this.set(FLD_PRESCRIPTOR, prescriptor.getId());
            String comment = other.getDisposalComment();
            if (comment != null && !comment.isEmpty()) {
                this.setDisposalComment(comment);
            }
        }
    }

    public static Prescription load(String id) {
        return new Prescription(id);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    protected Prescription() {
    }

    protected Prescription(String id) {
        super(id);
    }

    public void setBeginDate(String date) {
        TimeTool newDate = new TimeTool();
        if (date != null && !date.isEmpty()) {
            newDate.set(date);
        }
        this.set(FLD_DATE_FROM, newDate.toString(13));
    }

    public String getBeginDate() {
        String timestamp = Prescription.checkNull(this.get(FLD_DATE_FROM));
        if (!timestamp.isEmpty()) {
            TimeTool timetool = new TimeTool(timestamp);
            return timetool.toString(4);
        }
        return "";
    }

    public String getBeginTime() {
        String timestamp = Prescription.checkNull(this.get(FLD_DATE_FROM));
        if (!timestamp.isEmpty()) {
            TimeTool timetool = new TimeTool(timestamp);
            return timetool.toString(0);
        }
        return "";
    }

    public void setEndDate(String date) {
        TimeTool newDate = new TimeTool();
        if (date != null && !date.isEmpty()) {
            newDate.set(date);
        }
        this.set(FLD_DATE_UNTIL, newDate.toString(13));
    }

    public String getEndDate() {
        String timestamp = Prescription.checkNull(this.get(FLD_DATE_UNTIL));
        if (!timestamp.isEmpty()) {
            TimeTool timetool = new TimeTool(timestamp);
            return timetool.toString(4);
        }
        return "";
    }

    public String getEndTime() {
        String timestamp = Prescription.checkNull(this.get(FLD_DATE_UNTIL));
        if (!timestamp.isEmpty()) {
            TimeTool timetool = new TimeTool(timestamp);
            return timetool.toString(0);
        }
        return "";
    }

    @Override
    public String getLabel() {
        return this.getSimpleLabel() + " " + this.getDosis();
    }

    public String getSimpleLabel() {
        Artikel art = this.getArtikel();
        if (art != null) {
            return art.getLabel();
        }
        return "Fehler";
    }

    public Artikel getArtikel() {
        String art = this.get(FLD_ARTICLE);
        if (StringTool.isNothing((Object)art)) {
            return Artikel.load(this.get(FLD_ARTICLE_ID));
        }
        Optional article = StoreToStringServiceHolder.get().loadFromString(art);
        if (article.isPresent()) {
            return new ArtikelAdapter((IArticle)article.get());
        }
        return (Artikel)CoreHub.poFactory.createFromString(art);
    }

    public String getDosis() {
        return Prescription.checkNull(this.get(FLD_DOSAGE));
    }

    public static ArrayList<Float> getDoseAsFloats(String dosis) {
        ArrayList<Float> list = new ArrayList<Float>();
        ArrayList<Object> sub_list = new ArrayList();
        float num = 0.0f;
        if (dosis != null) {
            if (dosis.matches(special_num_at_start)) {
                list.add(Float.valueOf(Prescription.getNum(dosis.replace("~", ""))));
            } else if (dosis.matches("[0-9\u00bd\u00bc]+([xX][0-9]+(/[0-9]+)?|)")) {
                String[] dose = dosis.split("[xX]");
                float count = Prescription.getNum(dose[0]);
                num = dose.length > 1 ? Prescription.getNum(dose[1]) * count : Prescription.getNum(dose[0]);
                list.add(Float.valueOf(num));
            } else {
                sub_list = Prescription.getDoseAsFloats(dosis, "-");
                if (StringUtils.countMatches((CharSequence)dosis, (CharSequence)"-") > 1 && !sub_list.isEmpty()) {
                    return sub_list;
                }
                sub_list = Prescription.getDoseAsFloats(dosis, "/");
                if (StringUtils.countMatches((CharSequence)dosis, (CharSequence)"/") > 1 && !sub_list.isEmpty()) {
                    return sub_list;
                }
                if (dosis.indexOf(45) != -1 || dosis.indexOf(47) != -1) {
                    String[] dos = dosis.split("[- /]");
                    if (dos.length > 2) {
                        String[] stringArray = dos;
                        int n = dos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String d = stringArray[n2];
                            boolean hasDigit = d.matches("^[~/.]*[\u00bd\u00bc0-9].*");
                            if (d.indexOf(32) != -1) {
                                list.add(Float.valueOf(Prescription.getNum(d.substring(0, d.indexOf(32)))));
                            } else if (d.length() > 0 && hasDigit) {
                                list.add(Float.valueOf(Prescription.getNum(d)));
                            }
                            if (list.size() >= 4) {
                                return list;
                            }
                            ++n2;
                        }
                    } else if (dos.length > 1) {
                        list.add(Float.valueOf(Prescription.getNum(dos[1])));
                    }
                }
            }
        }
        return list;
    }

    private static ArrayList<Float> getDoseAsFloats(String dosis, String trennzeichen) {
        ArrayList<Float> list = new ArrayList<Float>();
        if (dosis.indexOf(45) != -1 || dosis.indexOf(47) != -1) {
            String[] dos = dosis.split(trennzeichen);
            if (dos.length > 2) {
                String[] stringArray = dos;
                int n = dos.length;
                int n2 = 0;
                while (n2 < n) {
                    String d = stringArray[n2];
                    boolean hasDigit = d.matches("^[~/.]*[\u00bd\u00bc0-9].*");
                    if (d.indexOf(32) != -1) {
                        list.add(Float.valueOf(Prescription.getNum(d.substring(0, d.indexOf(32)))));
                    } else if (d.length() > 0 && hasDigit) {
                        list.add(Float.valueOf(Prescription.getNum(d)));
                    } else if (d.length() == 0) {
                        list.add(Float.valueOf(0.0f));
                    }
                    if (list.size() >= 4) {
                        return list;
                    }
                    ++n2;
                }
            } else if (dos.length > 1) {
                list.add(Float.valueOf(Prescription.getNum(dos[1])));
            }
        }
        return list;
    }

    public static String[] getSignatureAsStringArray(String signature) {
        return Methods.getSignatureAsStringArray((String)signature);
    }

    public void setDosis(String newDose) {
        String oldDose = this.getDosis();
        if (!oldDose.equals(newDose)) {
            this.set(FLD_DOSAGE, newDose);
        }
    }

    public String getBemerkung() {
        return Prescription.checkNull(this.get(FLD_REMARK));
    }

    public void setBemerkung(String value) {
        this.set(FLD_REMARK, Prescription.checkNull(value));
    }

    public String getDisposalComment() {
        return Prescription.checkNull(this.getExtInfoStoredObjectByKey("disposalComment"));
    }

    public void setDisposalComment(String disposalComment) {
        this.setExtInfoStoredObjectByKey("disposalComment", disposalComment);
    }

    public Boolean isApplied() {
        String value = Prescription.checkNull(this.getExtInfoStoredObjectByKey(Constants.FLD_EXT_IS_APPLIED));
        return Boolean.valueOf(value);
    }

    public void setApplied(Boolean value) {
        this.setExtInfoStoredObjectByKey(Constants.FLD_EXT_IS_APPLIED, Boolean.toString(value));
    }

    public int getRecipeOrder() {
        String value = Prescription.checkNull(this.getExtInfoStoredObjectByKey("recipeOrder"));
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setRecipeOrder(int value) {
        this.setExtInfoStoredObjectByKey("recipeOrder", Integer.toString(value));
    }

    @Override
    public boolean delete() {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IPrescription.class, (Right)Right.UPDATE))) {
            this.stop(null);
            return true;
        }
        return false;
    }

    public boolean remove() {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IPrescription.class, (Right)Right.DELETE))) {
            return super.delete();
        }
        return false;
    }

    public void stop(TimeTool until) {
        if (until == null) {
            until = new TimeTool();
        }
        this.set(FLD_DATE_UNTIL, until.toString(13));
        IPersistentObject user = ElexisEventDispatcher.getSelected(Anwender.class);
        this.setExtInfoStoredObjectByKey("stopper", user.getId());
    }

    public SortedMap<TimeTool, String> getTerms() {
        TreeMap<TimeTool, String> ret = new TreeMap<TimeTool, String>();
        String raw = (String)this.getExtInfoStoredObjectByKey(FLD_EXT_TERMS);
        if (raw != null) {
            String[] terms;
            String[] stringArray = terms = raw.split("~#<");
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String[] flds;
                String term = stringArray[n2];
                if (term.length() > 0 && (flds = term.split("::")) != null && flds.length > 0) {
                    TimeTool date = new TimeTool(flds[0]);
                    String dose = "n/a";
                    if (flds.length > 1) {
                        dose = flds[1];
                    }
                    ret.put(date, dose);
                }
                ++n2;
            }
        }
        ret.put(new TimeTool(this.get(FLD_DATE_FROM)), this.get(FLD_DOSAGE));
        return ret;
    }

    public static float calculateTagesDosis(String dosis) throws NumberFormatException {
        float total = 0.0f;
        ArrayList<Float> res = Prescription.getDoseAsFloats(dosis);
        int j = 0;
        while (j < res.size()) {
            total += ((Float)res.get(j)).floatValue();
            ++j;
        }
        return total;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static float getNum(String num) {
        try {
            String n = num.trim();
            if (n.matches(special_num_at_start)) {
                return Prescription.getNum(n.substring(0, 1)) / Prescription.getNum(n.substring(2));
            }
            if (n.equalsIgnoreCase("\u00bd")) {
                return 0.5f;
            }
            if (n.equalsIgnoreCase("\u00bc")) {
                return 0.25f;
            }
            if (n.equalsIgnoreCase("1\u00bd")) {
                return 1.5f;
            }
            if (n.indexOf(47) != -1) {
                if (n.length() == 1) {
                    return 0.0f;
                }
                String[] bruch = n.split("/");
                if (bruch.length < 2) {
                    return 0.0f;
                }
                float zaehler = Float.parseFloat(bruch[0]);
                float nenner = Float.parseFloat(bruch[1]);
                if (nenner != 0.0f) return zaehler / nenner;
                return 0.0f;
            }
            if (n.toLowerCase().matches("^[0-9][,.]*[0-9]*x[0-9][,.]*[0-9]*$")) {
                n = n.replace("\\s", "");
                String[] nums = n.toLowerCase().split("x");
                float num1 = Float.parseFloat(nums[0].replace(",", "."));
                float num2 = Float.parseFloat(nums[1].replace(",", "."));
                return num1 * num2;
            }
            if (n.matches("^[0-9,]")) {
                n = n.replace(",", ".");
                return Float.parseFloat(n);
            }
            n = n.replace(",", ".");
            if ((n = n.replaceAll("[^\\d.]", "")).endsWith(".")) {
                n = n.substring(0, n.length() - 1);
            }
            if (!n.isEmpty()) return Float.parseFloat(n);
            return 0.0f;
        }
        catch (NumberFormatException e) {
            ElexisStatus status = new ElexisStatus(1, "ch.elexis.core.data", 0, e.getLocalizedMessage(), (Exception)e);
            ElexisStatus.fire((ElexisStatus)status);
            return 0.0f;
        }
    }

    public boolean isFixedMediation() {
        String[] vals = new String[2];
        this.get(new String[]{FLD_REZEPT_ID, FLD_DATE_UNTIL}, vals);
        return this.isFixedMedication(vals[0], vals[1]);
    }

    public boolean isFixedMedication(String rezeptId, String dateUntil) {
        boolean dateIsNull;
        boolean rezeptIdIsNull = rezeptId.length() == 0;
        boolean bl = dateIsNull = dateUntil.length() == 0;
        if (!dateIsNull) {
            TimeTool tt = new TimeTool(dateUntil);
            dateIsNull = tt.isAfter(new TimeTool());
        }
        return rezeptIdIsNull & dateIsNull;
    }

    public boolean isReserveMedication() {
        return this.getEntryType() == EntryType.RESERVE_MEDICATION;
    }

    public String getStopReason() {
        return (String)this.getExtInfoStoredObjectByKey("stopReason");
    }

    public void setStopReason(String stopReason) {
        this.setExtInfoStoredObjectByKey("stopReason", stopReason);
    }

    public boolean isStopped(TimeTool time) {
        String timestamp = Prescription.checkNull(this.get(FLD_DATE_UNTIL));
        if (!timestamp.isEmpty()) {
            TimeTool timetool = new TimeTool(timestamp);
            return timetool.isBefore(time, 1000);
        }
        return false;
    }

    @Nullable
    public Verrechnet getVerrechnetForAppliedMedication() {
        String verrechnetId = (String)this.getExtInfoStoredObjectByKey(FLD_EXT_VERRECHNET_ID);
        if (verrechnetId != null && verrechnetId.length() > 0) {
            return Verrechnet.load(verrechnetId);
        }
        return null;
    }

    public EntryType getEntryType() {
        int typeNum = this.getPrescType();
        if (typeNum != -1) {
            return EntryType.byNumeric((int)typeNum);
        }
        String rezeptId = this.getRaw(FLD_REZEPT_ID);
        if (rezeptId != null) {
            if (rezeptId.equals(FLD_REZEPTID_VAL_DIREKTABGABE)) {
                this.setEntryType(EntryType.SELF_DISPENSED);
                this.set(FLD_REZEPT_ID, "");
                return EntryType.SELF_DISPENSED;
            }
            this.setEntryType(EntryType.RECIPE);
            return EntryType.RECIPE;
        }
        return EntryType.FIXED_MEDICATION;
    }

    private int getPrescType() {
        String prescTypeString = this.get(FLD_PRESC_TYPE);
        if (prescTypeString != null && !prescTypeString.isEmpty()) {
            try {
                return Integer.parseInt(prescTypeString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setEntryType(EntryType type) {
        if (type == null) {
            type = EntryType.FIXED_MEDICATION;
        }
        this.set(FLD_PRESC_TYPE, Integer.toString(type.numericValue()));
    }

    @Nullable
    public IPersistentObject getLastDisposed() {
        EntryType entryType = this.getEntryType();
        if (entryType == EntryType.SELF_DISPENSED) {
            return this.getVerrechnetForAppliedMedication();
        }
        String rezeptId = this.get(FLD_REZEPT_ID);
        return this.getLastDisposed(rezeptId);
    }

    @Nullable
    public IPersistentObject getLastDisposed(String rezeptId) {
        if ("".equals(rezeptId)) {
            Query qre = new Query(Prescription.class);
            qre.add(FLD_PATIENT_ID, "=", this.get(FLD_PATIENT_ID));
            qre.add(FLD_ARTICLE, "=", this.get(FLD_ARTICLE));
            qre.add(FLD_REZEPT_ID, "<>", "");
            qre.orderBy(true, "lastupdate");
            List execute = qre.execute();
            if (!execute.isEmpty()) {
                return ((Prescription)execute.get(0)).getLastDisposed();
            }
            return null;
        }
        Query qre = new Query(Prescription.class);
        qre.add(FLD_PATIENT_ID, "=", this.get(FLD_PATIENT_ID));
        qre.add(FLD_ARTICLE, "=", this.get(FLD_ARTICLE));
        qre.add(FLD_REZEPT_ID, "<>", FLD_REZEPTID_VAL_DIREKTABGABE);
        qre.add(FLD_REZEPT_ID, "<>", "");
        qre.orderBy(true, "lastupdate");
        List execute = qre.execute();
        if (!execute.isEmpty()) {
            return Rezept.load(((Prescription)execute.get(0)).get(FLD_REZEPT_ID));
        }
        return null;
    }

    @Nullable
    public TimeTool getSuppliedUntilDate() {
        int packageSize;
        IPersistentObject po = this.getLastDisposed();
        if (po == null) {
            return null;
        }
        float tagesDosis = Prescription.calculateTagesDosis(this.getDosis());
        String disposeDateString = null;
        if (po instanceof Verrechnet) {
            disposeDateString = ((Verrechnet)po).getKons().get("Datum");
        } else if (po instanceof Rezept) {
            disposeDateString = ((Rezept)po).getDate();
        }
        if (disposeDateString == null || disposeDateString.length() < 1) {
            return null;
        }
        TimeTool disposeDate = new TimeTool(disposeDateString);
        int n = packageSize = this.getArtikel() != null ? this.getArtikel().getPackungsGroesse() : 0;
        if (packageSize == 0) {
            return null;
        }
        int noSuppliedDays = Math.round((float)packageSize / tagesDosis);
        disposeDate.addDays(noSuppliedDays);
        return disposeDate;
    }
}

