/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.AccountTransaction;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zahlung
extends PersistentObject {
    public static final String DATE = "Datum";
    public static final String AMMOUNT_CENTS = "Betragx100";
    public static final String REMARK = "Bemerkung";
    public static final String BILL_ID = "RechnungsID";
    static final String TABLENAME = "ZAHLUNGEN";

    static {
        Zahlung.addMapping(TABLENAME, BILL_ID, "Betragx100=Betrag", "Datum=S:D:Datum", REMARK);
    }

    public Zahlung(Rechnung rn, Money Betrag, String text, TimeTool date) {
        this.create(null);
        if (date == null) {
            date = new TimeTool();
        }
        String Datum = date.toString(4);
        this.set(new String[]{BILL_ID, AMMOUNT_CENTS, DATE, REMARK}, rn.getId(), Betrag.getCentsAsString(), Datum, text);
        new AccountTransaction(this);
        rn.addTrace("Zahlung", Betrag.getAmountAsString());
    }

    @Override
    public boolean delete() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM KONTO WHERE ID=").append(this.getWrappedId());
        Zahlung.getConnection().exec(sb.toString());
        Rechnung rn = this.getRechnung();
        if (rn != null) {
            rn.addTrace("Korrektur", "Zahlung gel\u00f6scht");
        }
        return super.delete();
    }

    public String getBemerkung() {
        return this.get(REMARK);
    }

    public Rechnung getRechnung() {
        return Rechnung.load(this.get(BILL_ID));
    }

    public Money getBetrag() {
        return new Money(Zahlung.checkZero(this.get(AMMOUNT_CENTS)));
    }

    public String getDatum() {
        return this.get(DATE);
    }

    public static Zahlung load(String id) {
        return new Zahlung(id);
    }

    protected Zahlung() {
    }

    protected Zahlung(String id) {
        super(id);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDatum()).append(": ").append(this.getBetrag().getAmountAsString());
        return sb.toString();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public AccountTransaction getTransaction() {
        Query query = new Query(AccountTransaction.class);
        query.add("ZahlungsID", "=", this.getId());
        List transactions = query.execute();
        if (!transactions.isEmpty()) {
            if (transactions.size() > 1) {
                Logger logger = LoggerFactory.getLogger(Zahlung.class);
                logger.warn("More than 1 transaction for payment. [" + this.storeToString() + "]");
            }
            return (AccountTransaction)transactions.get(0);
        }
        return null;
    }
}

