/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.data.LabItem;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class LabGroup
extends PersistentObject
implements Comparable<LabGroup> {
    private static final String TABLENAME = "LABGROUPS";
    private static final String GROUP_ITEM_TABLENAME = "LABGROUP_ITEM_JOINT";
    private JdbcLink j = LabGroup.getConnection();

    static {
        LabGroup.addMapping(TABLENAME, "Name", "Items=JOINT:GroupID:ItemID:LABGROUP_ITEM_JOINT");
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected LabGroup() {
    }

    protected LabGroup(String id) {
        super(id);
    }

    public LabGroup(String name, List<LabItem> items) {
        this.create(null);
        this.setName(name);
        this.addItems(items);
    }

    @Override
    public boolean delete() {
        this.removeAll();
        return super.delete();
    }

    public String getName() {
        return LabGroup.checkNull(this.get("Name"));
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public static LabGroup load(String id) {
        return new LabGroup(id);
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public int compareTo(LabGroup arg0) {
        LabGroup other = arg0;
        return this.getName().compareTo(other.getName());
    }

    public List<LabItem> getItems() {
        ArrayList<LabItem> items = new ArrayList<LabItem>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ItemID FROM LABGROUP_ITEM_JOINT").append(" WHERE GroupID = " + this.getWrappedId());
        JdbcLink.Stm stm = this.j.getStatement();
        ResultSet rs = stm.query(sql.toString());
        try {
            try {
                while (rs.next()) {
                    String id = rs.getString(1);
                    LabItem item = LabItem.load(id);
                    if (item.state() != 3) continue;
                    items.add(item);
                }
                rs.close();
            }
            catch (Exception ex) {
                ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Persistence error: " + ex.getMessage(), ex, 2);
                throw new PersistenceException((IStatus)status);
            }
        }
        finally {
            this.j.releaseStatement(stm);
        }
        return items;
    }

    public void addItem(LabItem item) {
        String exists;
        if (item != null && item.state() == 3 && StringTool.isNothing((Object)(exists = this.j.queryString("SELECT ItemID FROM LABGROUP_ITEM_JOINT WHERE GroupID = " + this.getWrappedId() + " AND ItemID = " + item.getWrappedId())))) {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO LABGROUP_ITEM_JOINT (GroupID, ItemID) VALUES (").append(this.getWrappedId()).append(",").append(item.getWrappedId()).append(")");
            this.j.exec(sql.toString());
        }
    }

    public void addItems(List<LabItem> items) {
        if (items != null) {
            for (LabItem item : items) {
                this.addItem(item);
            }
        }
    }

    public void setItems(List<LabItem> items) {
        this.removeAll();
        this.addItems(items);
    }

    public void removeItem(LabItem item) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM LABGROUP_ITEM_JOINT WHERE GroupID = ").append(this.getWrappedId()).append(" AND ").append("ItemID = ").append(item.getWrappedId());
        this.j.exec(sql.toString());
    }

    public void removeAll() {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM LABGROUP_ITEM_JOINT WHERE GroupID = ").append(this.getWrappedId());
        this.j.exec(sql.toString());
    }
}

